/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.Future;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.controlprogram.federated.MatrixLineagePair;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuaternaryFEDInstruction;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.QuaternaryOperator;

public class QuaternaryWSLossFEDInstruction
extends QuaternaryFEDInstruction {
    protected QuaternaryWSLossFEDInstruction(Operator operator, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out, String opcode, String instruction_str) {
        super(FEDInstruction.FEDType.Quaternary, operator, in1, in2, in3, in4, out, opcode, instruction_str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        CPOperand[] cPOperandArray;
        long[] varNewIn;
        FederatedRequest frB;
        ArrayList<FederatedRequest[]> frSliced;
        FederationMap fedMap;
        QuaternaryOperator qop = (QuaternaryOperator)this._optr;
        MatrixObject X = ec.getMatrixObject(this.input1);
        MatrixLineagePair U = ec.getMatrixLineagePair(this.input2);
        MatrixLineagePair V = ec.getMatrixLineagePair(this.input3);
        MatrixLineagePair W = null;
        if (qop.hasFourInputs()) {
            W = ec.getMatrixLineagePair(this._input4);
        }
        if (X.isFederated()) {
            FederatedRequest[] tmpFrS;
            fedMap = X.getFedMapping();
            frSliced = new ArrayList<FederatedRequest[]>();
            frB = null;
            varNewIn = new long[qop.hasFourInputs() ? 4 : 3];
            varNewIn[0] = fedMap.getID();
            if (X.isFederated(FTypes.FType.ROW)) {
                if (U.isFederated(FTypes.FType.ROW) && fedMap.isAligned(U.getFedMapping(), FTypes.AlignType.ROW)) {
                    varNewIn[1] = U.getFedMapping().getID();
                } else {
                    tmpFrS = fedMap.broadcastSliced(U, false);
                    varNewIn[1] = tmpFrS[0].getID();
                    frSliced.add(tmpFrS);
                }
                frB = fedMap.broadcast(V);
                varNewIn[2] = frB.getID();
            } else if (X.isFederated(FTypes.FType.COL)) {
                frB = fedMap.broadcast(U);
                varNewIn[1] = frB.getID();
                if (V.isFederated() && fedMap.isAligned(V.getFedMapping(), FTypes.AlignType.COL, FTypes.AlignType.COL_T)) {
                    varNewIn[2] = V.getFedMapping().getID();
                } else {
                    tmpFrS = fedMap.broadcastSliced(V, true);
                    varNewIn[2] = tmpFrS[0].getID();
                    frSliced.add(tmpFrS);
                }
            } else {
                throw new DMLRuntimeException("Federated WSLoss only supported for ROW or COLUMN partitioned federated data.");
            }
            if (W != null) {
                if (W.isFederated() && fedMap.isAligned(W.getFedMapping(), FTypes.AlignType.FULL)) {
                    varNewIn[3] = W.getFedMapping().getID();
                } else {
                    tmpFrS = fedMap.broadcastSliced(W, false);
                    varNewIn[3] = tmpFrS[0].getID();
                    frSliced.add(tmpFrS);
                }
            }
            if (qop.hasFourInputs()) {
                CPOperand[] cPOperandArray2 = new CPOperand[4];
                cPOperandArray2[0] = this.input1;
                cPOperandArray2[1] = this.input2;
                cPOperandArray2[2] = this.input3;
                cPOperandArray = cPOperandArray2;
                cPOperandArray2[3] = this._input4;
            } else {
                CPOperand[] cPOperandArray3 = new CPOperand[3];
                cPOperandArray3[0] = this.input1;
                cPOperandArray3[1] = this.input2;
                cPOperandArray = cPOperandArray3;
                cPOperandArray3[2] = this.input3;
            }
        } else {
            throw new DMLRuntimeException("Unsupported federated inputs (X, U, V, W) = (" + X.isFederated() + ", " + U.isFederated() + ", " + V.isFederated() + ", " + (Serializable)(W != null ? Boolean.valueOf(W.isFederated()) : "none") + ")");
        }
        FederatedRequest frComp = FederationUtils.callInstruction(this.instString, this.output, cPOperandArray, varNewIn);
        FederatedRequest frGet = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, frComp.getID());
        ArrayList<FederatedRequest> frC = new ArrayList<FederatedRequest>();
        frC.add(fedMap.cleanup(this.getTID(), frComp.getID()));
        FederatedRequest[] frAll = (FederatedRequest[])ArrayUtils.addAll((Object[])new FederatedRequest[]{frB, frComp, frGet}, (Object[])frC.toArray(new FederatedRequest[0]));
        Future<FederatedResponse>[] response = frSliced.isEmpty() ? fedMap.execute(this.getTID(), true, frAll) : fedMap.executeMultipleSlices(this.getTID(), true, (FederatedRequest[][])frSliced.toArray((T[])new FederatedRequest[0][]), frAll);
        AggregateUnaryOperator aop = InstructionUtils.parseBasicAggregateUnaryOperator("uak+");
        ec.setVariable(this.output.getName(), FederationUtils.aggScalar(aop, response));
    }
}

