/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class GroupedAggregate
extends Lop {
    private HashMap<String, Lop> _inputParams;
    private static final String opcode = "groupedagg";
    public static final String COMBINEDINPUT = "combinedinput";
    private boolean _weights = false;
    private boolean _broadcastGroups = false;
    private int _numThreads = 1;

    public GroupedAggregate(HashMap<String, Lop> inputParameterLops, boolean weights, Expression.DataType dt, Expression.ValueType vt) {
        this(inputParameterLops, dt, vt, LopProperties.ExecType.MR);
        this._weights = weights;
    }

    public GroupedAggregate(HashMap<String, Lop> inputParameterLops, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.GroupedAgg, dt, vt);
        this.init(inputParameterLops, dt, vt, et);
    }

    public GroupedAggregate(HashMap<String, Lop> inputParameterLops, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, boolean broadcastGroups) {
        super(Lop.Type.GroupedAgg, dt, vt);
        this.init(inputParameterLops, dt, vt, et);
        this._broadcastGroups = broadcastGroups;
    }

    public GroupedAggregate(HashMap<String, Lop> inputParameterLops, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.GroupedAgg, dt, vt);
        this.init(inputParameterLops, dt, vt, et);
        this._numThreads = k;
    }

    private void init(HashMap<String, Lop> inputParameterLops, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        if (et == LopProperties.ExecType.MR) {
            this.addInput(inputParameterLops.get(COMBINEDINPUT));
            inputParameterLops.get(COMBINEDINPUT).addOutput(this);
            for (Map.Entry<String, Lop> e : inputParameterLops.entrySet()) {
                String k = e.getKey();
                Lop lop = e.getValue();
                if (k.equalsIgnoreCase(COMBINEDINPUT)) continue;
                this.addInput(lop);
                lop.addOutput(this);
            }
            this._inputParams = inputParameterLops;
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = true;
            this.lps.addCompatibility(JobType.GROUPED_AGG);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.MapAndReduce, breaksAlignment, aligner, definesMRJob);
        } else {
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.addInput(inputParameterLops.get("target"));
            inputParameterLops.get("target").addOutput(this);
            this.addInput(inputParameterLops.get("groups"));
            inputParameterLops.get("groups").addOutput(this);
            for (Map.Entry<String, Lop> e : inputParameterLops.entrySet()) {
                String k = e.getKey();
                Lop lop = e.getValue();
                if (k.equalsIgnoreCase("target") || k.equalsIgnoreCase("groups")) continue;
                this.addInput(lop);
                lop.addOutput(this);
            }
            this._inputParams = inputParameterLops;
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "Operation = GroupedAggregate";
    }

    @Override
    public String getInstructions(String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(opcode);
        sb.append("\u00b0");
        if (this._inputParams.get("target") == null || this._inputParams.get("groups") == null || this._inputParams.get("fn") == null) {
            throw new LopsException(this.printErrorLocation() + "Invalid parameters to groupedAggregate -- \"target\", \"groups\", \"fn\" must be provided");
        }
        String targetVar = this._inputParams.get("target").getOutputParameters().getLabel();
        String groupsVar = this._inputParams.get("groups").getOutputParameters().getLabel();
        sb.append("target");
        sb.append("=");
        sb.append(targetVar);
        sb.append("\u00b0");
        sb.append("groups");
        sb.append("=");
        sb.append(groupsVar);
        if (this._inputParams.get("weights") != null) {
            sb.append("\u00b0");
            sb.append("weights");
            sb.append("=");
            sb.append(this._inputParams.get("weights").getOutputParameters().getLabel());
        }
        for (Map.Entry<String, Lop> e : this._inputParams.entrySet()) {
            String name = e.getKey();
            if (name.equalsIgnoreCase("target") || name.equalsIgnoreCase("groups") || name.equalsIgnoreCase("weights")) continue;
            Lop value = e.getValue();
            String valueString = value.prepScalarLabel();
            sb.append("\u00b0");
            sb.append(name);
            sb.append("=");
            sb.append(valueString);
        }
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append("\u00b0");
            sb.append("k");
            sb.append("=");
            sb.append(this._numThreads);
        } else if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append("broadcast");
            sb.append("=");
            sb.append(this._broadcastGroups);
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index, int output_index) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(opcode);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index));
        sb.append("\u00b0");
        Lop funcLop = this._inputParams.get("fn");
        sb.append(funcLop.prepScalarInputOperand(this.getExecType()));
        if (this._inputParams.get("order") != null) {
            sb.append("\u00b0");
            Lop orderLop = this._inputParams.get("order");
            sb.append(orderLop.prepScalarInputOperand(this.getExecType()));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        sb.append("\u00b0");
        sb.append(this._weights);
        sb.append("\u00b0");
        Lop ngroups = this._inputParams.get("ngroups");
        sb.append(ngroups != null ? ngroups.prepScalarInputOperand(this.getExecType()) : "-1");
        return sb.toString();
    }
}

