/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.QueueSender;
import javax.jms.Session;
import javax.jms.TopicPublisher;
import javax.transaction.UserTransaction;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSMessageSender {
    private static final Log log = LogFactory.getLog(JMSMessageSender.class);
    private Connection connection = null;
    private Session session = null;
    private MessageProducer producer = null;
    private Destination destination = null;
    private int cacheLevel = 1;
    private boolean jmsSpec11 = true;
    private Boolean isQueue = null;

    public JMSMessageSender(Connection connection, Session session, MessageProducer producer, Destination destination, int cacheLevel, boolean jmsSpec11, Boolean isQueue) {
        this.connection = connection;
        this.session = session;
        this.producer = producer;
        this.destination = destination;
        this.cacheLevel = cacheLevel;
        this.jmsSpec11 = jmsSpec11;
        this.isQueue = isQueue;
    }

    public JMSMessageSender(JMSConnectionFactory jmsConnectionFactory, String targetAddress) {
        this.cacheLevel = jmsConnectionFactory.getCacheLevel();
        this.jmsSpec11 = jmsConnectionFactory.isJmsSpec11();
        this.connection = jmsConnectionFactory.getConnection();
        this.session = jmsConnectionFactory.getSession(this.connection);
        this.destination = jmsConnectionFactory.getSharedDestination() == null ? jmsConnectionFactory.getDestination(JMSUtils.getDestination(targetAddress), "generic") : jmsConnectionFactory.getSharedDestination();
        this.producer = jmsConnectionFactory.getMessageProducer(this.connection, this.session, this.destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void send(Message message, MessageContext msgCtx) {
        block57: {
            boolean sendingSuccessful;
            Boolean rollbackOnly;
            Boolean jtaCommit;
            block56: {
                block55: {
                    jtaCommit = this.getBooleanProperty(msgCtx, "JTA_COMMIT_AFTER_SEND");
                    rollbackOnly = this.getBooleanProperty(msgCtx, "SET_ROLLBACK_ONLY");
                    Boolean persistent = this.getBooleanProperty(msgCtx, "JMS_DELIVERY_MODE");
                    Integer priority = this.getIntegerProperty(msgCtx, "JMS_PRIORITY");
                    Integer timeToLive = this.getIntegerProperty(msgCtx, "JMS_TIME_TO_LIVE");
                    if (rollbackOnly != null && rollbackOnly.booleanValue()) {
                        jtaCommit = Boolean.FALSE;
                    }
                    if (persistent != null) {
                        try {
                            this.producer.setDeliveryMode(2);
                        }
                        catch (JMSException e) {
                            this.handleException("Error setting JMS Producer for PERSISTENT delivery", (Exception)((Object)e));
                        }
                    }
                    if (priority != null) {
                        try {
                            this.producer.setPriority(priority.intValue());
                        }
                        catch (JMSException e) {
                            this.handleException("Error setting JMS Producer priority to : " + priority, (Exception)((Object)e));
                        }
                    }
                    if (timeToLive != null) {
                        try {
                            this.producer.setTimeToLive((long)timeToLive.intValue());
                        }
                        catch (JMSException e) {
                            this.handleException("Error setting JMS Producer TTL to : " + timeToLive, (Exception)((Object)e));
                        }
                    }
                    sendingSuccessful = false;
                    if (this.jmsSpec11 || this.isQueue == null) {
                        this.producer.send(message);
                    } else if (this.isQueue.booleanValue()) {
                        ((QueueSender)this.producer).send(message);
                    } else {
                        ((TopicPublisher)this.producer).publish(message);
                    }
                    String msgId = null;
                    try {
                        msgId = message.getJMSMessageID();
                        if (msgId != null) {
                            msgCtx.setProperty("JMS_MESSAGE_ID", (Object)msgId);
                        }
                    }
                    catch (JMSException ignore) {
                        // empty catch block
                    }
                    sendingSuccessful = true;
                    if (!log.isDebugEnabled()) break block55;
                    log.debug((Object)("Sent Message Context ID : " + msgCtx.getMessageID() + " with JMS Message ID : " + msgId + " to destination : " + this.producer.getDestination()));
                }
                Object var12_16 = null;
                if (jtaCommit == null) break block56;
                UserTransaction ut = (UserTransaction)msgCtx.getProperty("UserTransaction");
                if (ut != null) {
                    try {
                        if (sendingSuccessful && jtaCommit.booleanValue()) {
                            ut.commit();
                        } else {
                            ut.rollback();
                        }
                        msgCtx.removeProperty("UserTransaction");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " JTA Transaction"));
                        }
                        break block57;
                    }
                    catch (Exception e2) {
                        this.handleException("Error committing/rolling back JTA transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, e2);
                    }
                }
                break block57;
            }
            try {
                if (this.session.getTransacted()) {
                    if (sendingSuccessful && (rollbackOnly == null || !rollbackOnly.booleanValue())) {
                        this.session.commit();
                    } else {
                        this.session.rollback();
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                }
                break block57;
            }
            catch (JMSException e3) {
                this.handleException("Error committing/rolling back local (i.e. session) transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, (Exception)((Object)e3));
            }
            break block57;
            {
                catch (JMSException e) {
                    log.error((Object)("Error sending message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination), (Throwable)e);
                    Object var12_17 = null;
                    if (jtaCommit != null) {
                        UserTransaction ut = (UserTransaction)msgCtx.getProperty("UserTransaction");
                        if (ut == null) break block57;
                        try {
                            if (sendingSuccessful && jtaCommit.booleanValue()) {
                                ut.commit();
                            } else {
                                ut.rollback();
                            }
                            msgCtx.removeProperty("UserTransaction");
                            if (log.isDebugEnabled()) {
                                log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " JTA Transaction"));
                            }
                            break block57;
                        }
                        catch (Exception e2) {
                            this.handleException("Error committing/rolling back JTA transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, e2);
                        }
                        break block57;
                    }
                    try {
                        if (this.session.getTransacted()) {
                            if (sendingSuccessful && (rollbackOnly == null || !rollbackOnly.booleanValue())) {
                                this.session.commit();
                            } else {
                                this.session.rollback();
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                        }
                        break block57;
                    }
                    catch (JMSException e3) {
                        this.handleException("Error committing/rolling back local (i.e. session) transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, (Exception)((Object)e3));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                if (jtaCommit != null) {
                    UserTransaction ut = (UserTransaction)msgCtx.getProperty("UserTransaction");
                    if (ut != null) {
                        try {
                            if (sendingSuccessful && jtaCommit.booleanValue()) {
                                ut.commit();
                            } else {
                                ut.rollback();
                            }
                            msgCtx.removeProperty("UserTransaction");
                            if (log.isDebugEnabled()) {
                                log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " JTA Transaction"));
                            }
                        }
                        catch (Exception e2) {
                            this.handleException("Error committing/rolling back JTA transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, e2);
                        }
                    }
                } else {
                    try {
                        if (this.session.getTransacted()) {
                            if (sendingSuccessful && (rollbackOnly == null || !rollbackOnly.booleanValue())) {
                                this.session.commit();
                            } else {
                                this.session.rollback();
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                        }
                    }
                    catch (JMSException e3) {
                        this.handleException("Error committing/rolling back local (i.e. session) transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, (Exception)((Object)e3));
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.producer != null && this.cacheLevel < 4) {
            try {
                try {
                    this.producer.close();
                }
                catch (JMSException e) {
                    log.error((Object)"Error closing JMS MessageProducer after send", (Throwable)e);
                    Object var3_2 = null;
                    this.producer = null;
                }
                Object var3_1 = null;
                this.producer = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.producer = null;
                throw throwable;
            }
        }
        if (this.session != null && this.cacheLevel < 2) {
            try {
                try {
                    this.session.close();
                }
                catch (JMSException e) {
                    log.error((Object)"Error closing JMS Session after send", (Throwable)e);
                    Object var5_10 = null;
                    this.session = null;
                }
                Object var5_9 = null;
                this.session = null;
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                this.session = null;
                throw throwable;
            }
        }
        if (this.connection != null && this.cacheLevel < 1) {
            try {
                try {
                    this.connection.close();
                }
                catch (JMSException e) {
                    log.error((Object)"Error closing JMS Connection after send", (Throwable)e);
                    Object var7_14 = null;
                    this.connection = null;
                }
                Object var7_13 = null;
                this.connection = null;
            }
            catch (Throwable throwable) {
                Object var7_15 = null;
                this.connection = null;
                throw throwable;
            }
        }
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        throw new AxisJMSException(message, e);
    }

    private Boolean getBooleanProperty(MessageContext msgCtx, String name) {
        Object o = msgCtx.getProperty(name);
        if (o != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof String) {
                return Boolean.valueOf((String)o);
            }
        }
        return null;
    }

    private Integer getIntegerProperty(MessageContext msgCtx, String name) {
        Object o = msgCtx.getProperty(name);
        if (o != null) {
            if (o instanceof Integer) {
                return (Integer)o;
            }
            if (o instanceof String) {
                return Integer.parseInt((String)o);
            }
        }
        return null;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setProducer(MessageProducer producer) {
        this.producer = producer;
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public MessageProducer getProducer() {
        return this.producer;
    }

    public Session getSession() {
        return this.session;
    }
}

