/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.streampark.common.conf.ConfigConst;
import org.apache.streampark.common.util.DeflaterUtils;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.enums.ConfigFileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TableName(value="t_flink_config")
public class ApplicationConfig {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfig.class);
    @TableId(type=IdType.AUTO)
    private Long id;
    private Long appId;
    private Integer format;
    private Integer version = 1;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String content;
    private Date createTime;
    private Boolean latest;
    private transient boolean effective = false;

    public void setToApplication(Application application) {
        String unzipString = DeflaterUtils.unzipString((String)this.content);
        String encode = Base64.getEncoder().encodeToString(unzipString.getBytes());
        application.setConfig(encode);
        application.setConfigId(this.id);
        application.setFormat(this.format);
    }

    public Map<String, String> readConfig() {
        ConfigFileType fileType = ConfigFileType.of(this.format);
        HashMap configs = null;
        if (fileType != null) {
            switch (fileType) {
                case YAML: {
                    configs = PropertiesUtils.fromYamlTextAsJava((String)DeflaterUtils.unzipString((String)this.content));
                    break;
                }
                case PROPERTIES: {
                    configs = PropertiesUtils.fromPropertiesTextAsJava((String)DeflaterUtils.unzipString((String)this.content));
                    break;
                }
                case HOCON: {
                    configs = PropertiesUtils.fromHoconTextAsJava((String)DeflaterUtils.unzipString((String)this.content));
                    break;
                }
                default: {
                    configs = Collections.emptyMap();
                }
            }
        }
        if (configs != null && !configs.isEmpty()) {
            return configs.entrySet().stream().collect(Collectors.toMap(entry -> {
                String key = (String)entry.getKey();
                if (key.startsWith(ConfigConst.KEY_FLINK_OPTION_PREFIX())) {
                    key = key.substring(ConfigConst.KEY_FLINK_OPTION_PREFIX().length());
                } else if (key.startsWith(ConfigConst.KEY_FLINK_PROPERTY_PREFIX())) {
                    key = key.substring(ConfigConst.KEY_FLINK_PROPERTY_PREFIX().length());
                } else if (key.startsWith(ConfigConst.KEY_FLINK_TABLE_PREFIX())) {
                    key = key.substring(ConfigConst.KEY_FLINK_TABLE_PREFIX().length());
                } else if (key.startsWith(ConfigConst.KEY_APP_PREFIX())) {
                    key = key.substring(ConfigConst.KEY_APP_PREFIX().length());
                } else if (key.startsWith(ConfigConst.KEY_SQL_PREFIX())) {
                    key = key.substring(ConfigConst.KEY_SQL_PREFIX().length());
                }
                return key;
            }, Map.Entry::getValue));
        }
        return Collections.emptyMap();
    }

    public Long getId() {
        return this.id;
    }

    public Long getAppId() {
        return this.appId;
    }

    public Integer getFormat() {
        return this.format;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getContent() {
        return this.content;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Boolean getLatest() {
        return this.latest;
    }

    public boolean isEffective() {
        return this.effective;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setFormat(Integer format) {
        this.format = format;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setLatest(Boolean latest) {
        this.latest = latest;
    }

    public void setEffective(boolean effective) {
        this.effective = effective;
    }
}

