/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartBackoffTimeStrategy;
import org.apache.flink.util.Preconditions;

public class FixedDelayRestartBackoffTimeStrategy
implements RestartBackoffTimeStrategy {
    private final int maxNumberRestartAttempts;
    private final long backoffTimeMS;
    private final String strategyString;
    private int currentRestartAttempt;

    FixedDelayRestartBackoffTimeStrategy(int maxNumberRestartAttempts, long backoffTimeMS) {
        Preconditions.checkArgument((maxNumberRestartAttempts >= 0 ? 1 : 0) != 0, (Object)"Maximum number of restart attempts must be at least 0.");
        Preconditions.checkArgument((backoffTimeMS >= 0L ? 1 : 0) != 0, (Object)"Backoff time between restart attempts must be at least 0 ms.");
        this.maxNumberRestartAttempts = maxNumberRestartAttempts;
        this.backoffTimeMS = backoffTimeMS;
        this.currentRestartAttempt = 0;
        this.strategyString = this.generateStrategyString();
    }

    @Override
    public boolean canRestart() {
        return this.currentRestartAttempt <= this.maxNumberRestartAttempts;
    }

    @Override
    public long getBackoffTime() {
        return this.backoffTimeMS;
    }

    public int getMaxNumberRestartAttempts() {
        return this.maxNumberRestartAttempts;
    }

    @Override
    public void notifyFailure(Throwable cause) {
        ++this.currentRestartAttempt;
    }

    public String toString() {
        return this.strategyString;
    }

    private String generateStrategyString() {
        StringBuilder str = new StringBuilder("FixedDelayRestartBackoffTimeStrategy(");
        str.append("maxNumberRestartAttempts=");
        str.append(this.maxNumberRestartAttempts);
        str.append(", backoffTimeMS=");
        str.append(this.backoffTimeMS);
        str.append(")");
        return str.toString();
    }

    public static FixedDelayRestartBackoffTimeStrategyFactory createFactory(Configuration configuration) {
        int maxAttempts = configuration.getInteger(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS);
        long delay = ((Duration)configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY)).toMillis();
        return new FixedDelayRestartBackoffTimeStrategyFactory(maxAttempts, delay);
    }

    public static class FixedDelayRestartBackoffTimeStrategyFactory
    implements RestartBackoffTimeStrategy.Factory {
        private final int maxNumberRestartAttempts;
        private final long backoffTimeMS;

        public FixedDelayRestartBackoffTimeStrategyFactory(int maxNumberRestartAttempts, long backoffTimeMS) {
            this.maxNumberRestartAttempts = maxNumberRestartAttempts;
            this.backoffTimeMS = backoffTimeMS;
        }

        @Override
        public RestartBackoffTimeStrategy create() {
            return new FixedDelayRestartBackoffTimeStrategy(this.maxNumberRestartAttempts, this.backoffTimeMS);
        }
    }
}

