/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.testing.mock.sling.context.models.OsgiServiceModel;
import org.apache.sling.testing.mock.sling.context.models.RequestAttributeModel;
import org.apache.sling.testing.mock.sling.context.models.ServiceInterface;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.apache.sling.testing.mock.sling.services.MockMimeTypeService;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractModelAdapterFactoryUtilTest {
    protected abstract SlingContext context();

    @Test
    public void testRequestAttribute() {
        this.context().jakartaRequest().setAttribute("prop1", (Object)"myValue");
        RequestAttributeModel model = (RequestAttributeModel)this.context().jakartaRequest().adaptTo(RequestAttributeModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)"myValue", (Object)model.getProp1());
    }

    @Test
    public void testOsgiService() {
        this.context().registerService(MimeTypeService.class, new MockMimeTypeService());
        OsgiServiceModel model = (OsgiServiceModel)this.context().resourceResolver().adaptTo(OsgiServiceModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getMimeTypeService());
        Assert.assertEquals((Object)"text/html", (Object)model.getMimeTypeService().getMimeType("html"));
    }

    @Test
    public void testInvalidAdapt() {
        OsgiServiceModel model = (OsgiServiceModel)this.context().jakartaRequest().adaptTo(OsgiServiceModel.class);
        Assert.assertNull((Object)model);
    }

    @Test
    public void testAdaptToInterface() {
        this.context().jakartaRequest().setAttribute("prop1", (Object)"myValue");
        ServiceInterface model = (ServiceInterface)this.context().jakartaRequest().adaptTo(ServiceInterface.class);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)"myValue", (Object)model.getPropValue());
    }
}

