/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.sling.testing.mock.jcr.MockRow;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class MockQueryResult
implements QueryResult {
    private final List<Node> nodes;
    private final List<String> columnNames;
    private boolean simulateUnknownSize;

    public MockQueryResult(List<Node> nodes) {
        this(nodes, Collections.emptyList());
    }

    public MockQueryResult(List<Node> nodes, List<String> columnNames) {
        this.columnNames = columnNames;
        this.nodes = nodes;
    }

    public void setSimulateUnknownSize(boolean simulateUnknownSize) {
        this.simulateUnknownSize = simulateUnknownSize;
    }

    public String[] getColumnNames() throws RepositoryException {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    public RowIterator getRows() throws RepositoryException {
        return new RowIteratorAdapter(this.nodes.stream().map(node -> new MockRow(this.columnNames, (Node)node)).iterator());
    }

    public NodeIterator getNodes() throws RepositoryException {
        if (this.simulateUnknownSize) {
            return new NodeIteratorAdapter(this.nodes.iterator(), -1L);
        }
        return new NodeIteratorAdapter(this.nodes);
    }

    public String[] getSelectorNames() throws RepositoryException {
        return new String[0];
    }
}

