/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.packaging.impl.SharedDistributionPackage;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemState;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.DistributionQueueProvider;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleQueueDispatchingStrategy
implements DistributionQueueDispatchingStrategy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String[] queueNames;

    public MultipleQueueDispatchingStrategy(String[] queueNames) {
        this.queueNames = Arrays.copyOf(queueNames, queueNames.length);
    }

    @Override
    public Iterable<DistributionQueueItemStatus> add(@NotNull DistributionPackage distributionPackage, @NotNull DistributionQueueProvider queueProvider) throws DistributionException {
        if (!(distributionPackage instanceof SharedDistributionPackage) && this.queueNames.length > 1) {
            throw new DistributionException("distribution package must be a shared package to be added in multiple queues");
        }
        DistributionQueueItem queueItem = this.getItem(distributionPackage);
        ArrayList<DistributionQueueItemStatus> result = new ArrayList<DistributionQueueItemStatus>();
        DistributionPackageUtils.acquire(distributionPackage, this.queueNames);
        for (String queueName : this.queueNames) {
            DistributionQueue queue = queueProvider.getQueue(queueName);
            DistributionQueueItemStatus status = new DistributionQueueItemStatus(DistributionQueueItemState.ERROR, queue.getName());
            DistributionQueueEntry queueEntry = queue.add(queueItem);
            if (queueEntry != null) {
                status = queueEntry.getStatus();
            } else {
                DistributionPackageUtils.release(distributionPackage, queueName);
                this.log.error("cannot add package {} to queue {}", (Object)distributionPackage.getId(), (Object)queueName);
            }
            result.add(status);
        }
        return result;
    }

    @Override
    @NotNull
    public List<String> getQueueNames() {
        return Arrays.asList(this.queueNames);
    }

    private DistributionQueueItem getItem(DistributionPackage distributionPackage) {
        return DistributionPackageUtils.toQueueItem(distributionPackage);
    }
}

