/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import javax.jcr.SimpleCredentials;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.CredentialExpiredException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.jetbrains.annotations.NotNull;

public final class FailureCodesMapper {
    @NotNull
    public static AuthenticationHandler.FAILURE_REASON_CODES getFailureReason(AuthenticationInfo authInfo, Exception reason) {
        AuthenticationHandler.FAILURE_REASON_CODES code = AuthenticationHandler.FAILURE_REASON_CODES.UNKNOWN;
        if (reason instanceof LoginException) {
            Object creds;
            code = reason.getCause() instanceof CredentialExpiredException ? ((creds = authInfo.get("user.jcr.credentials")) instanceof SimpleCredentials && ((SimpleCredentials)creds).getAttribute("PasswordHistoryException") != null ? AuthenticationHandler.FAILURE_REASON_CODES.PASSWORD_EXPIRED_AND_NEW_PASSWORD_IN_HISTORY : AuthenticationHandler.FAILURE_REASON_CODES.PASSWORD_EXPIRED) : (reason.getCause() instanceof AccountLockedException ? AuthenticationHandler.FAILURE_REASON_CODES.ACCOUNT_LOCKED : (reason.getCause() instanceof AccountNotFoundException ? AuthenticationHandler.FAILURE_REASON_CODES.ACCOUNT_NOT_FOUND : (FailureCodesMapper.isTokenCredentialsExpiredException(reason) ? AuthenticationHandler.FAILURE_REASON_CODES.EXPIRED_TOKEN : AuthenticationHandler.FAILURE_REASON_CODES.INVALID_LOGIN)));
        }
        return code;
    }

    private static boolean isTokenCredentialsExpiredException(Exception reason) {
        return reason.getCause() != null && reason.getCause().getClass().getSimpleName().equals("TokenCredentialsExpiredException");
    }

    private FailureCodesMapper() {
    }
}

