/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmEntity;

public class AlarmMessageFormatter {
    private List<String> formatSegments;
    private List<ValueFrom> valueFroms;

    public AlarmMessageFormatter(String format) {
        if (format == null) {
            format = "";
        }
        this.formatSegments = new ArrayList<String>();
        this.valueFroms = new ArrayList<ValueFrom>();
        boolean match = false;
        int idx = 0;
        do {
            int end;
            match = false;
            int start = format.indexOf("{", idx);
            if (start > -1 && (end = format.indexOf("}", start)) > -1) {
                String name;
                switch (name = format.substring(start + 1, end)) {
                    case "id": {
                        this.valueFroms.add(ValueFrom.ID);
                        break;
                    }
                    case "name": {
                        this.valueFroms.add(ValueFrom.NAME);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Var [" + name + "] in alarm message [" + format + "] is illegal");
                    }
                }
                this.formatSegments.add(format.substring(idx, start));
                idx = end + 1;
                match = true;
            }
            if (match) continue;
            this.formatSegments.add(format.substring(idx));
        } while (match);
    }

    public String format(AlarmEntity alarmEntity) {
        StringBuilder message = new StringBuilder();
        block4: for (int i = 0; i < this.formatSegments.size(); ++i) {
            message.append(this.formatSegments.get(i));
            if (i == this.formatSegments.size() - 1) continue;
            switch (this.valueFroms.get(i).ordinal()) {
                case 0: {
                    message.append(alarmEntity.getId0());
                    continue block4;
                }
                case 1: {
                    message.append(alarmEntity.getName());
                }
            }
        }
        return message.toString();
    }

    @Generated
    public List<String> getFormatSegments() {
        return this.formatSegments;
    }

    @Generated
    public List<ValueFrom> getValueFroms() {
        return this.valueFroms;
    }

    public static enum ValueFrom {
        ID,
        NAME;

    }
}

