/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileThreadSnapshotRecord;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCProfileThreadSnapshotQueryDAO
implements IProfileThreadSnapshotQueryDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<ProfileThreadSnapshotRecord> queryRecords(String taskId) throws IOException {
        List<String> snapshotTables = this.tableHelper.getTablesWithinTTL("profile_task_segment_snapshot");
        ArrayList<ProfileThreadSnapshotRecord> segments = new ArrayList<ProfileThreadSnapshotRecord>();
        for (String table : snapshotTables) {
            segments.addAll(this.querySegments(taskId, table));
        }
        return segments;
    }

    protected ArrayList<ProfileThreadSnapshotRecord> querySegments(String taskId, String table) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("*").append(" from ").append(table);
        sql.append(" where ").append("table_name").append(" = ?").append(" and ").append("task_id").append(" = ? and ").append("sequence").append(" = 0");
        return (ArrayList)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
            ArrayList<ProfileThreadSnapshotRecord> records = new ArrayList<ProfileThreadSnapshotRecord>();
            while (resultSet.next()) {
                ProfileThreadSnapshotRecord record = new ProfileThreadSnapshotRecord();
                record.setTaskId(resultSet.getString("task_id"));
                record.setSegmentId(resultSet.getString("segment_id"));
                record.setDumpTime(resultSet.getLong("dump_time"));
                record.setSequence(resultSet.getInt("sequence"));
                String dataBinaryBase64 = resultSet.getString("stack_binary");
                if (StringUtil.isNotEmpty((String)dataBinaryBase64)) {
                    record.setStackBinary(Base64.getDecoder().decode(dataBinaryBase64));
                }
                records.add(record);
            }
            return records;
        }, new Object[]{"profile_task_segment_snapshot", taskId});
    }

    public int queryMinSequence(String segmentId, long start, long end) throws IOException {
        return this.querySequenceWithAgg("min", segmentId, start, end);
    }

    public int queryMaxSequence(String segmentId, long start, long end) throws IOException {
        return this.querySequenceWithAgg("max", segmentId, start, end);
    }

    public List<ProfileThreadSnapshotRecord> queryRecords(String segmentId, int minSequence, int maxSequence) throws IOException {
        List<String> tables = this.tableHelper.getTablesWithinTTL("profile_task_segment_snapshot");
        ArrayList<ProfileThreadSnapshotRecord> results = new ArrayList<ProfileThreadSnapshotRecord>();
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            sql.append("select * from ").append(table).append(" where ");
            sql.append("table_name").append(" = ? ");
            sql.append(" and ").append("segment_id").append(" = ? ");
            sql.append(" and ").append("sequence").append(" >= ? ");
            sql.append(" and ").append("sequence").append(" < ? ");
            Object[] params = new Object[]{"profile_task_segment_snapshot", segmentId, minSequence, maxSequence};
            this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    ProfileThreadSnapshotRecord record = new ProfileThreadSnapshotRecord();
                    record.setTaskId(resultSet.getString("task_id"));
                    record.setSegmentId(resultSet.getString("segment_id"));
                    record.setDumpTime(resultSet.getLong("dump_time"));
                    record.setSequence(resultSet.getInt("sequence"));
                    String dataBinaryBase64 = resultSet.getString("stack_binary");
                    if (StringUtil.isNotEmpty((String)dataBinaryBase64)) {
                        record.setStackBinary(Base64.getDecoder().decode(dataBinaryBase64));
                    }
                    results.add(record);
                }
                return null;
            }, params);
        }
        return results;
    }

    private int querySequenceWithAgg(String aggType, String segmentId, long start, long end) throws IOException {
        List<String> tables = this.tableHelper.getTablesWithinTTL("profile_task_segment_snapshot");
        IntStream.Builder result = IntStream.builder();
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            sql.append("select ").append(aggType).append("(").append("sequence").append(") from ").append(table).append(" where ");
            sql.append("table_name").append(" = ?");
            sql.append(" and ").append("segment_id").append(" = ? ");
            sql.append(" and ").append("dump_time").append(" >= ? ");
            sql.append(" and ").append("dump_time").append(" <= ? ");
            Object[] params = new Object[]{"profile_task_segment_snapshot", segmentId, start, end};
            this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                if (resultSet.next()) {
                    result.add(resultSet.getInt(1));
                }
                return null;
            }, params);
        }
        switch (aggType) {
            case "min": {
                return result.build().min().orElse(-1);
            }
            case "max": {
                return result.build().max().orElse(-1);
            }
        }
        throw new UnsupportedOperationException("Unsupported agg type: " + aggType);
    }

    @Generated
    public JDBCProfileThreadSnapshotQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

