/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gco;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlValue;
import org.apache.sis.util.iso.Names;
import org.opengis.util.GenericName;
import org.opengis.util.NameSpace;

@XmlSeeAlso(value={Local.class, Scoped.class})
public class NameValue {
    @XmlValue
    String value;
    @XmlAttribute
    @XmlSchemaType(name="anyURI", namespace="http://www.opengis.net/gml/3.2")
    String codeSpace;

    public final void setName(GenericName name) {
        this.value = name.toString();
        NameSpace scope = name.scope();
        if (scope != null && !scope.isGlobal()) {
            this.codeSpace = scope.name().toString();
        }
    }

    public GenericName getName() {
        return Names.parseGenericName(this.codeSpace, null, this.value);
    }

    @XmlRootElement(name="ScopedName")
    public static final class Scoped
    extends NameValue {
    }

    @XmlRootElement(name="LocalName")
    public static final class Local
    extends NameValue {
        @Override
        public GenericName getName() {
            return Names.createLocalName(this.codeSpace, null, this.value);
        }
    }
}

