/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.math.NumberType;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataVisitor;
import org.apache.sis.metadata.PropertyComparator;
import org.apache.sis.metadata.PropertyInformation;
import org.apache.sis.metadata.SpecialCases;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.UnmodifiableMetadataException;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.internal.shared.Unsafe;
import org.apache.sis.util.internal.shared.ViewAsSet;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.UML;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.citation.Citation;

class PropertyAccessor {
    static final int COUNT_FIRST = 0;
    static final int COUNT_SHALLOW = 1;
    static final int COUNT_DEEP = 2;
    static final int RETURN_NULL = 0;
    static final int RETURN_PREVIOUS = 1;
    static final int APPEND = 2;
    static final int IGNORE_READ_ONLY = 3;
    private static final Method EXTRA_GETTER;
    final Class<?> type;
    final Class<?> implementation;
    private final int allCount;
    private final int standardCount;
    private final Method[] getters;
    private final Method[] setters;
    private final String[] names;
    private final Class<?>[] elementTypes;
    private final Map<String, Integer> mapping;
    private volatile transient ObjectConverter<?, ?> lastConverter;
    private transient ExtendedElementInformation[] informations;

    PropertyAccessor(Class<?> type, Class<?> implementation, Class<?> standardImpl) {
        int allCount;
        assert (type.isAssignableFrom(implementation)) : implementation;
        this.type = type;
        this.implementation = implementation;
        this.getters = PropertyAccessor.getGetters(type, implementation, standardImpl);
        int standardCount = allCount = this.getters.length;
        if (allCount != 0 && this.getters[allCount - 1] == EXTRA_GETTER) {
            if (!EXTRA_GETTER.getDeclaringClass().isAssignableFrom(implementation)) {
                --allCount;
            }
            --standardCount;
        }
        while (standardCount != 0 && this.isDeprecated(standardCount - 1)) {
            --standardCount;
        }
        this.allCount = allCount;
        this.standardCount = standardCount;
        this.mapping = JDK19.newHashMap((int)allCount);
        this.names = new String[allCount];
        this.elementTypes = new Class[allCount];
        Method[] setters = null;
        Class[] arguments = new Class[1];
        for (int i = 0; i < allCount; ++i) {
            Class elementType;
            Method setter;
            Method getter;
            block21: {
                Class<?> returnType;
                Integer index = i;
                getter = this.getters[i];
                String name = getter.getName();
                int base = PropertyComparator.prefix(name).length();
                this.addMapping(name, index);
                this.names[i] = PropertyComparator.toPropertyName(name, base);
                this.addMappingWithLowerCase(this.names[i], index);
                UML annotation = getter.getAnnotation(UML.class);
                if (annotation != null) {
                    this.addMappingWithLowerCase(annotation.identifier().intern(), index);
                }
                arguments[0] = returnType = getter.getReturnType();
                if (name.length() > base) {
                    int lo = name.codePointAt(base);
                    int up = Character.toUpperCase(lo);
                    int length = name.length();
                    StringBuilder buffer = new StringBuilder(length - base + 5).append("set");
                    if (lo != up) {
                        buffer.appendCodePoint(up).append(name, base + Character.charCount(lo), length);
                    } else {
                        buffer.append(name, base, length);
                    }
                    name = buffer.toString();
                }
                setter = null;
                try {
                    setter = implementation.getMethod(name, arguments);
                }
                catch (NoSuchMethodException e) {
                    try {
                        getter = implementation.getMethod(getter.getName(), null);
                    }
                    catch (NoSuchMethodException error) {
                        throw new AssertionError((Object)error);
                    }
                    Class<?> clazz = returnType;
                    returnType = getter.getReturnType();
                    if (clazz == returnType) break block21;
                    arguments[0] = returnType;
                    try {
                        setter = implementation.getMethod(name, arguments);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (setter != null) {
                if (setters == null) {
                    setters = new Method[allCount];
                }
                setters[i] = setter;
            }
            if (Collection.class.isAssignableFrom(elementType = getter.getReturnType()) || Classes.isParameterizedProperty(elementType)) {
                elementType = Classes.boundOfParameterizedProperty((Method)getter);
                if (elementType == null) {
                    elementType = Classes.boundOfParameterizedProperty((Method)this.getters[i]);
                }
            } else if (Map.class.isAssignableFrom(elementType)) {
                elementType = Map.Entry.class;
            }
            this.elementTypes[i] = NumberType.primitiveToWrapper(elementType);
        }
        this.setters = setters;
    }

    private void addMapping(String name, Integer index) {
        Integer old;
        if (!name.isEmpty() && (old = this.mapping.put(name, index)) != null && !old.equals(index)) {
            boolean deprecated = this.isDeprecated(index);
            if (deprecated == this.isDeprecated(old)) {
                throw new IllegalStateException(Errors.format((short)39, (Object)(Classes.getShortName(this.type) + "." + name)));
            }
            if (deprecated) {
                this.mapping.put(name, old);
            }
        }
    }

    private void addMappingWithLowerCase(String name, Integer index) {
        this.addMapping(name, index);
        String lower = name.toLowerCase(Locale.ROOT);
        if (!lower.equals(name)) {
            this.addMapping(lower, index);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Method[] getGetters(Class<?> type, Class<?> implementation, Class<?> standardImpl) {
        Object[] getters = implementation.getMethods();
        HashMap indices = JDK19.newHashMap((int)getters.length);
        boolean hasExtraGetter = false;
        int count = 0;
        for (Method method : getters) {
            void var10_10;
            Integer pi;
            String name;
            if (!Classes.isPossibleGetter((Method)method) || (name = method.getName()).startsWith("set") || SpecialCases.exclude(type, name)) continue;
            if (type == implementation) {
                if (!type.isInterface() && !method.isAnnotationPresent(UML.class)) {
                    continue;
                }
            } else {
                try {
                    Method method2 = type.getMethod(name, null);
                }
                catch (NoSuchMethodException e) {
                    if (!method.isAnnotationPresent(UML.class)) continue;
                }
            }
            if ((pi = indices.put(name, count)) != null) {
                Class<?> pt = ((Method)getters[pi]).getReturnType();
                Class<?> ct = var10_10.getReturnType();
                if (ct.isAssignableFrom(pt)) continue;
                if (pt.isAssignableFrom(ct)) {
                    getters[pi.intValue()] = var10_10;
                    continue;
                }
                throw new ClassCastException(Errors.format((short)58, (Object)(Classes.getShortName(type) + "." + name), ct, pt));
            }
            getters[count++] = var10_10;
            if (hasExtraGetter) continue;
            hasExtraGetter = name.equals(EXTRA_GETTER.getName());
        }
        Arrays.sort(getters, 0, count, new PropertyComparator(implementation, standardImpl));
        if (!hasExtraGetter) {
            if (getters.length == count) {
                getters = (Method[])Arrays.copyOf(getters, count + 1);
            }
            getters[count++] = EXTRA_GETTER;
        }
        getters = (Method[])ArraysExt.resize((Object[])getters, (int)count);
        return getters;
    }

    final int count() {
        return this.standardCount;
    }

    final int indexOf(String name, boolean mandatory) {
        String key;
        Integer index = this.mapping.get(name);
        if (index == null && ((key = CharSequences.replace((CharSequence)name, (CharSequence)" ", (CharSequence)"").toString().toLowerCase(Locale.ROOT).strip()) == name || (index = this.mapping.get(key)) == null)) {
            if (!mandatory) {
                return -1;
            }
            throw new IllegalArgumentException(Errors.format((short)149, this.type, (Object)name));
        }
        return index;
    }

    final Obligation obligation(int index) {
        UML uml;
        if (index >= 0 && index < this.names.length && (uml = this.getters[index].getAnnotation(UML.class)) != null) {
            return uml.obligation();
        }
        return null;
    }

    final String name(int index, KeyNamePolicy keyPolicy) {
        if (index >= 0 && index < this.names.length) {
            switch (keyPolicy) {
                case UML_IDENTIFIER: {
                    UML uml = this.getters[index].getAnnotation(UML.class);
                    if (uml != null) {
                        return uml.identifier().intern();
                    }
                }
                case JAVABEANS_PROPERTY: {
                    return this.names[index];
                }
                case METHOD_NAME: {
                    return this.getters[index].getName();
                }
                case SENTENCE: {
                    return CharSequences.camelCaseToSentence((CharSequence)this.names[index]).toString();
                }
            }
        }
        return null;
    }

    Class<?> type(int index, TypeValuePolicy policy) {
        if (index >= 0 && index < this.allCount) {
            switch (policy) {
                case ELEMENT_TYPE: {
                    return this.elementTypes[index];
                }
                case PROPERTY_TYPE: {
                    Class<?> returnType = this.getters[index].getReturnType();
                    return Classes.isParameterizedProperty(returnType) ? this.elementTypes[index] : returnType;
                }
                case DECLARING_INTERFACE: {
                    return this.getters[index].getDeclaringClass();
                }
                case DECLARING_CLASS: {
                    Method getter = this.getters[index];
                    if (this.implementation != this.type) {
                        try {
                            getter = this.implementation.getMethod(getter.getName(), null);
                        }
                        catch (NoSuchMethodException error) {
                            throw new AssertionError((Object)error);
                        }
                    }
                    return getter.getDeclaringClass();
                }
            }
        }
        return null;
    }

    final boolean isCollectionOrMap(int index) {
        if (index >= 0 && index < this.allCount) {
            Class<?> pt = this.getters[index].getReturnType();
            return Collection.class.isAssignableFrom(pt) || Map.class.isAssignableFrom(pt);
        }
        return false;
    }

    final boolean isMap(int index) {
        return index >= 0 && index < this.allCount && this.elementTypes[index] == Map.Entry.class;
    }

    private boolean isDeprecated(int index) {
        return PropertyComparator.isDeprecated(this.implementation, this.getters[index]);
    }

    final synchronized ExtendedElementInformation information(Citation standard, int index) {
        ExtendedElementInformation[] informations = this.informations;
        if (informations == null) {
            this.informations = informations = new PropertyInformation[this.standardCount];
        }
        if (index < 0 || index >= informations.length) {
            return null;
        }
        PropertyInformation information = informations[index];
        if (information == null) {
            ValueRange range;
            Class<?> elementType = this.elementTypes[index];
            String name = this.name(index, KeyNamePolicy.UML_IDENTIFIER);
            Method getter = this.getters[index];
            try {
                range = this.implementation.getMethod(getter.getName(), null).getAnnotation(ValueRange.class);
            }
            catch (NoSuchMethodException error) {
                throw new AssertionError((Object)error);
            }
            informations[index] = information = new PropertyInformation(standard, name, getter, elementType, range);
        }
        return information;
    }

    CharSequence remarks(int index, Object metadata) {
        return null;
    }

    private static boolean isImmutable(Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        if (collection instanceof CheckedContainer) {
            return ((CheckedContainer)collection).getMutability() == CheckedContainer.Mutability.IMMUTABLE;
        }
        return false;
    }

    static <E> Collection<E> snapshot(Collection<E> data) {
        if (PropertyAccessor.isImmutable(data)) {
            return data;
        }
        boolean isSet = data instanceof Set;
        switch (data.size()) {
            case 0: {
                return isSet ? Collections.emptySet() : Collections.emptyList();
            }
            case 1: {
                E value = data.iterator().next();
                return isSet ? Collections.singleton(value) : Collections.singletonList(value);
            }
        }
        ViewAsSet copy = Arrays.asList(data.toArray());
        return isSet ? new ViewAsSet((Collection)copy) : copy;
    }

    static <K, V> Map<K, V> snapshot(Map<K, V> data) {
        if (data == null) {
            return null;
        }
        switch (data.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> entry = data.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        List<Map.Entry> copy = Arrays.asList((Map.Entry[])data.entrySet().toArray(Map.Entry[]::new));
        final ViewAsSet entries = new ViewAsSet(copy);
        return new AbstractMap<K, V>(){

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return entries;
            }
        };
    }

    final boolean isWritable() {
        return this.setters != null;
    }

    final boolean isWritable(int index) {
        return index >= 0 && index < this.allCount && this.setters != null && this.setters[index] != null;
    }

    Object get(int index, Object metadata) throws BackingStoreException {
        return index >= 0 && index < this.allCount ? PropertyAccessor.get(this.getters[index], metadata) : null;
    }

    private static Object get(Method method, Object metadata) throws BackingStoreException {
        assert (method.getReturnType() != Void.TYPE) : method;
        try {
            try {
                return method.invoke(metadata, (Object[])null);
            }
            catch (IllegalArgumentException e) {
                if (method.getDeclaringClass().isInstance(metadata)) {
                    throw e;
                }
                try {
                    Method specific = metadata.getClass().getMethod(method.getName(), method.getParameterTypes());
                    if (method.getReturnType().equals(specific.getReturnType())) {
                        return specific.invoke(metadata, (Object[])null);
                    }
                }
                catch (NoSuchMethodException specific) {
                    // empty catch block
                }
                return null;
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError(method.toString(), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new BackingStoreException(cause);
        }
    }

    Object set(int index, Object metadata, Object value, int mode) throws UnmodifiableMetadataException, ClassCastException, BackingStoreException {
        if (index < 0 || index >= this.allCount) {
            return null;
        }
        if (this.setters != null) {
            Method getter = this.getters[index];
            Method setter = this.setters[index];
            if (setter != null) {
                Map snapshot;
                Object oldValue;
                switch (mode) {
                    case 0: 
                    case 3: {
                        oldValue = null;
                        snapshot = null;
                        break;
                    }
                    case 2: {
                        oldValue = PropertyAccessor.get(getter, metadata);
                        snapshot = null;
                        break;
                    }
                    case 1: {
                        oldValue = PropertyAccessor.get(getter, metadata);
                        if (oldValue instanceof Collection) {
                            snapshot = PropertyAccessor.snapshot((Collection)oldValue);
                            break;
                        }
                        if (oldValue instanceof Map) {
                            snapshot = PropertyAccessor.snapshot((Map)oldValue);
                            break;
                        }
                        snapshot = oldValue;
                        break;
                    }
                    default: {
                        throw new AssertionError(mode);
                    }
                }
                Object[] newValues = new Object[]{value};
                Boolean changed = this.convert(getter, metadata, oldValue, newValues, this.elementTypes[index], mode == 2);
                if (changed == null && (changed = Boolean.valueOf(mode == 0 || mode == 3 || newValues[0] != oldValue)).booleanValue() && mode == 2 && !ValueExistencePolicy.isNullOrEmpty(oldValue)) {
                    return null;
                }
                if (changed.booleanValue()) {
                    PropertyAccessor.set(setter, metadata, newValues);
                }
                return mode == 2 ? changed : snapshot;
            }
        }
        if (mode == 3) {
            return UnmodifiableMetadataException.class;
        }
        throw new UnmodifiableMetadataException(Errors.format((short)24, (Object)(this.type.getSimpleName() + "." + this.names[index])));
    }

    private static void set(Method setter, Object metadata, Object[] newValues) throws BackingStoreException {
        try {
            setter.invoke(metadata, newValues);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new BackingStoreException(cause);
        }
    }

    private Boolean convert(Method getter, Object metadata, Object oldValue, Object[] newValues, Class<?> elementType, boolean append) throws ClassCastException, BackingStoreException {
        assert (newValues.length == 1);
        Collection<Object> newValue = newValues[0];
        Class targetType = getter.getReturnType();
        if (newValue == null) {
            if (targetType.isPrimitive()) {
                newValues[0] = NumberType.forNumberClass(targetType).nilValue();
            }
            return null;
        }
        Boolean changed = null;
        if (!Collection.class.isAssignableFrom(targetType)) {
            if (newValue instanceof Collection) {
                Iterator it = ((Collection)newValue).iterator();
                if (!it.hasNext()) {
                    newValues[0] = null;
                    return null;
                }
                Object next = it.next();
                if (!it.hasNext()) {
                    newValue = next;
                }
            }
            targetType = NumberType.primitiveToWrapper(targetType);
        } else {
            List<Object> elementList;
            Object[] objectArray;
            boolean isCollection = newValue instanceof Collection;
            if (isCollection) {
                objectArray = ((Collection)newValue).toArray();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = newValue;
            }
            Object[] elements = objectArray;
            newValue = elementList = Arrays.asList(elements);
            Collection addTo = null;
            if (!isCollection || append) {
                if (oldValue == null) {
                    oldValue = PropertyAccessor.get(getter, metadata);
                }
                if (oldValue != null) {
                    addTo = (Collection)oldValue;
                    if (addTo instanceof CheckedContainer) {
                        elementType = ((CheckedContainer)addTo).getElementType();
                    }
                    newValue = addTo;
                }
            }
            if (elementType != null) {
                this.convert(elements, elementType);
            }
            if (addTo != null) {
                changed = Unsafe.addAll((Collection)addTo, elementList);
            }
        }
        newValues[0] = newValue;
        this.convert(newValues, targetType);
        return changed;
    }

    private void convert(Object[] elements, Class<?> targetType) throws ClassCastException {
        boolean hasNewConverter = false;
        ObjectConverter converter = null;
        for (int i = 0; i < elements.length; ++i) {
            Class<?> sourceType;
            Object value = elements[i];
            if (value == null || targetType.isAssignableFrom(sourceType = value.getClass())) continue;
            try {
                if (converter == null) {
                    converter = this.lastConverter;
                }
                if (converter == null || converter.getSourceClass() != sourceType || converter.getTargetClass() != targetType) {
                    converter = ObjectConverters.find(sourceType, targetType);
                    hasNewConverter = true;
                }
                elements[i] = converter.apply(value);
                continue;
            }
            catch (UnconvertibleObjectException cause) {
                throw (ClassCastException)new ClassCastException(Errors.format((short)64, targetType, sourceType)).initCause(cause);
            }
        }
        if (hasNewConverter) {
            this.lastConverter = converter;
        }
    }

    final int count(Object metadata, ValueExistencePolicy valuePolicy, int mode) throws BackingStoreException {
        assert (this.type.isInstance(metadata)) : metadata;
        if (valuePolicy == ValueExistencePolicy.ALL && mode != 2) {
            return this.count();
        }
        int count = 0;
        block5: for (int i = 0; i < this.standardCount; ++i) {
            Object value = PropertyAccessor.get(this.getters[i], metadata);
            if (valuePolicy.isSkipped(value)) continue;
            switch (mode) {
                case 0: {
                    return 1;
                }
                case 1: {
                    ++count;
                    continue block5;
                }
                case 2: {
                    count += this.isCollectionOrMap(i) ? Math.max(PropertyAccessor.size(value), 1) : 1;
                    continue block5;
                }
                default: {
                    throw new AssertionError(mode);
                }
            }
        }
        return count;
    }

    static int size(Object c) {
        if (c == null) {
            return 0;
        }
        if (c instanceof Collection) {
            return ((Collection)c).size();
        }
        if (c instanceof Map) {
            return ((Map)c).size();
        }
        return 1;
    }

    public boolean equals(Object metadata1, Object metadata2, ComparisonMode mode) throws BackingStoreException {
        assert (this.type.isInstance(metadata1)) : metadata1;
        assert (this.type.isInstance(metadata2)) : metadata2;
        for (int i = 0; i < this.standardCount; ++i) {
            boolean equals;
            Method method = this.getters[i];
            Object value1 = PropertyAccessor.get(method, metadata1);
            Object value2 = PropertyAccessor.get(method, metadata2);
            if (ValueExistencePolicy.isNullOrEmpty(value1) && ValueExistencePolicy.isNullOrEmpty(value2) || (equals = !(!(value1 instanceof Double) && !(value1 instanceof Float) || !(value2 instanceof Double) && !(value2 instanceof Float)) ? Numerics.epsilonEqual((double)((Number)value1).doubleValue(), (double)((Number)value2).doubleValue(), (ComparisonMode)mode) : Utilities.deepEquals((Object)value1, (Object)value2, (ComparisonMode)mode))) continue;
            assert (mode != ComparisonMode.DEBUG) : this.type.getSimpleName() + "." + this.names[i] + " differ.";
            return false;
        }
        if (mode == ComparisonMode.STRICT && EXTRA_GETTER.getDeclaringClass().isInstance(metadata2)) {
            Object value1 = PropertyAccessor.get(EXTRA_GETTER, metadata1);
            Object value2 = PropertyAccessor.get(EXTRA_GETTER, metadata2);
            if (!ValueExistencePolicy.isNullOrEmpty(value1) || !ValueExistencePolicy.isNullOrEmpty(value2)) {
                return Utilities.deepEquals((Object)value1, (Object)value2, (ComparisonMode)mode);
            }
        }
        return true;
    }

    final void walkReadable(MetadataVisitor<?> visitor, Object metadata) throws Exception {
        assert (this.type.isInstance(metadata)) : metadata;
        for (int i = 0; i < this.standardCount; ++i) {
            Object result;
            visitor.setCurrentProperty(this.names[i]);
            Object value = PropertyAccessor.get(this.getters[i], metadata);
            if (value == null || (result = visitor.visit(this.elementTypes[i], value)) == value) continue;
            if (result == MetadataVisitor.SKIP_SIBLINGS) break;
            this.set(i, metadata, result, 3);
        }
    }

    final void walkWritable(MetadataVisitor<?> visitor, Object source, Object target) throws Exception {
        assert (this.type.isInstance(source)) : source;
        assert (this.type.isInstance(target)) : target;
        if (this.setters == null || !this.implementation.isInstance(target)) {
            return;
        }
        Object[] arguments = new Object[1];
        for (int i = 0; i < this.allCount; ++i) {
            visitor.setCurrentProperty(this.names[i]);
            Method setter = this.setters[i];
            if (setter == null || setter.isAnnotationPresent(Deprecated.class)) continue;
            Object value = PropertyAccessor.get(this.getters[i], source);
            Object result = visitor.visit(this.elementTypes[i], value);
            if (!(source == target ? result != value : !ValueExistencePolicy.isNullOrEmpty(result))) continue;
            if (result == MetadataVisitor.SKIP_SIBLINGS) break;
            arguments[0] = result;
            PropertyAccessor.set(setter, target, arguments);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(60);
        buffer.append("PropertyAccessor[").append(this.standardCount).append(" getters");
        int extra = this.allCount - this.standardCount;
        if (extra != 0) {
            buffer.append(" (+").append(extra).append(" ext.)");
        }
        if (this.setters != null) {
            int c = 0;
            for (Method setter : this.setters) {
                if (setter == null) continue;
                ++c;
            }
            buffer.append(" & ").append(c).append(" setters");
        }
        buffer.append(" in ").append(Classes.getShortName(this.implementation));
        if (this.type != this.implementation) {
            buffer.append(':').append(Classes.getShortName(this.type));
        }
        return buffer.append(']').toString();
    }

    static {
        try {
            EXTRA_GETTER = IdentifiedObject.class.getMethod("getIdentifiers", null);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

