/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.sis.coordinate.DefaultCoordinateMetadata;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.internal.shared.DirectPositionView;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.base.GridResourceWrapper;
import org.apache.sis.storage.base.StoreResource;
import org.apache.sis.storage.geotiff.ImageFileDirectory;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.NameSpace;

final class MultiResolutionImage
extends GridResourceWrapper
implements StoreResource {
    private NameSpace namespace;
    private final ImageFileDirectory[] levels;
    private final double[][] resolutions;
    private volatile CoordinateOperation lastOperation;

    MultiResolutionImage(List<ImageFileDirectory> overviews) {
        this.levels = (ImageFileDirectory[])overviews.toArray(ImageFileDirectory[]::new);
        this.resolutions = new double[this.levels.length][];
    }

    public final DataStore getOriginator() {
        return this.levels[0].getOriginator();
    }

    public final Optional<Resource.FileSet> getFileSet() throws DataStoreException {
        return this.levels[0].getFileSet();
    }

    protected final Object getSynchronizationLock() {
        return this.levels[0].getSynchronizationLock();
    }

    protected GridCoverageResource createSource() throws DataStoreException {
        try {
            return this.getImageFileDirectory(0);
        }
        catch (IOException e) {
            throw this.levels[0].reader.store.errorIO(e);
        }
    }

    private ImageFileDirectory getImageFileDirectory(int index) throws IOException, DataStoreException {
        assert (Thread.holdsLock(this.getSynchronizationLock()));
        ImageFileDirectory dir = this.levels[index];
        if (dir.hasDeferredEntries) {
            dir.reader.resolveDeferredEntries(dir);
        }
        if (dir.validateMandatoryTags() && index != 0) {
            if (this.namespace == null) {
                ImageFileDirectory base = this.levels[0];
                this.namespace = base.reader.store.nameFactory.createNameSpace(base.getIdentifier().get(), null);
            }
            dir.setOverviewIdentifier(this.namespace, index);
        }
        return dir;
    }

    private double[] resolution(int level) throws DataStoreException {
        double[] resolution = this.resolutions[level];
        if (resolution == null) {
            try {
                ImageFileDirectory image = this.getImageFileDirectory(level);
                ImageFileDirectory base = this.getImageFileDirectory(0);
                double[] scales = image.initReducedResolution(base);
                GridGeometry geometry = base.getGridGeometry();
                if (geometry.isDefined(8)) {
                    GridExtent fullExtent = geometry.getExtent();
                    DirectPositionView.Double poi = new DirectPositionView.Double(fullExtent.getPointOfInterest(PixelInCell.CELL_CENTER));
                    MatrixSIS gridToCRS = MatrixSIS.castOrCopy((Matrix)geometry.getGridToCRS(PixelInCell.CELL_CENTER).derivative((DirectPosition)poi));
                    resolution = gridToCRS.multiply(scales);
                } else {
                    resolution = scales;
                }
                int i = Math.min(2, resolution.length);
                Arrays.fill(scales, 2, i, Double.NaN);
                while (--i >= 0) {
                    resolution[i] = Math.abs(resolution[i]);
                }
                this.resolutions[level] = resolution;
            }
            catch (TransformException e) {
                throw new DataStoreReferencingException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw this.levels[level].reader.store.errorIO(e);
            }
        }
        return resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<double[]> getResolutions() throws DataStoreException {
        double[][] copy = new double[this.resolutions.length][];
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            for (int i = 0; i < copy.length; ++i) {
                copy[i] = (double[])this.resolution(i).clone();
            }
        }
        return Arrays.asList(copy);
    }

    private double[] convertResolutionOf(GridGeometry domain) throws DataStoreException {
        if (domain == null || !domain.isDefined(16)) {
            return null;
        }
        double[] resolution = domain.getResolution(true);
        if (domain.isDefined(3)) {
            try {
                MathTransform domainToCoverage;
                CoordinateOperation op = this.lastOperation;
                if (op == null || !domain.getCoordinateReferenceSystem().equals((Object)op.getSourceCRS())) {
                    GridGeometry targetGrid = this.getGridGeometry();
                    CoordinateOperationContext context = new CoordinateOperationContext();
                    targetGrid.getGeographicExtent().ifPresent(arg_0 -> ((CoordinateOperationContext)context).addAreaOfInterest(arg_0));
                    targetGrid.getConstantCoordinates().ifPresent(arg_0 -> ((CoordinateOperationContext)context).setConstantCoordinates(arg_0));
                    this.lastOperation = op = CRS.findOperation((DefaultCoordinateMetadata)domain.getCoordinateMetadata(), (DefaultCoordinateMetadata)targetGrid.getCoordinateMetadata(), (CoordinateOperationContext)context);
                }
                if (!(domainToCoverage = op.getMathTransform()).isIdentity()) {
                    DirectPositionView.Double poi = new DirectPositionView.Double(domain.getExtent().getPointOfInterest(PixelInCell.CELL_CENTER));
                    poi = domain.getGridToCRS(PixelInCell.CELL_CENTER).transform((DirectPosition)poi, null);
                    MatrixSIS derivative = MatrixSIS.castOrCopy((Matrix)domainToCoverage.derivative((DirectPosition)poi));
                    resolution = derivative.multiply(resolution);
                    for (int i = 0; i < resolution.length; ++i) {
                        resolution[i] = Math.abs(resolution[i]);
                    }
                }
            }
            catch (TransformException | FactoryException e) {
                throw new DataStoreReferencingException(e.getMessage(), e);
            }
        }
        return resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        double[] request = this.convertResolutionOf(domain);
        int level = request != null ? this.resolutions.length : 1;
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            ImageFileDirectory image;
            block5: while (--level > 0) {
                double[] resolution = this.resolution(level);
                int i = Math.min(request.length, 2);
                while (--i >= 0) {
                    if (request[i] >= resolution[i]) continue;
                    continue block5;
                }
                break block5;
            }
            try {
                image = this.getImageFileDirectory(level);
            }
            catch (IOException e) {
                throw this.levels[level].reader.store.errorIO(e);
            }
            image.setLoadingStrategy(this.getLoadingStrategy());
            return image.read(domain, ranges);
        }
    }
}

