/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetModelSnapshotsResponse;
import co.elastic.clients.elasticsearch.ml.Page;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetModelSnapshotsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean desc;
    @Nullable
    private final DateTime end;
    @Nullable
    private final Integer from;
    private final String jobId;
    @Nullable
    private final Page page;
    @Nullable
    private final Integer size;
    @Nullable
    private final String snapshotId;
    @Nullable
    private final String sort;
    @Nullable
    private final DateTime start;
    public static final JsonpDeserializer<GetModelSnapshotsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetModelSnapshotsRequest::setupGetModelSnapshotsRequestDeserializer);
    public static final Endpoint<GetModelSnapshotsRequest, GetModelSnapshotsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetModelSnapshotsRequest, GetModelSnapshotsResponse>("es/ml.get_model_snapshots", request -> "POST", request -> {
        boolean _snapshotId = true;
        int _jobId = 2;
        int propsSet = 0;
        if (request.snapshotId() != null) {
            propsSet |= 1;
        }
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/model_snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshotId, buf);
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/model_snapshots");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _snapshotId = true;
        int _jobId = 2;
        int propsSet = 0;
        if (request.snapshotId() != null) {
            propsSet |= 1;
        }
        if ((propsSet |= 2) == 3) {
            params.put("jobId", request.jobId);
            params.put("snapshotId", request.snapshotId);
        }
        if (propsSet == 2) {
            params.put("jobId", request.jobId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetModelSnapshotsResponse._DESERIALIZER);

    private GetModelSnapshotsRequest(Builder builder) {
        this.desc = builder.desc;
        this.end = builder.end;
        this.from = builder.from;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.page = builder.page;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.sort = builder.sort;
        this.start = builder.start;
    }

    public static GetModelSnapshotsRequest of(Function<Builder, ObjectBuilder<GetModelSnapshotsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean desc() {
        return this.desc;
    }

    @Nullable
    public final DateTime end() {
        return this.end;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Page page() {
        return this.page;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final String snapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public final String sort() {
        return this.sort;
    }

    @Nullable
    public final DateTime start() {
        return this.start;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.desc != null) {
            generator.writeKey("desc");
            generator.write(this.desc.booleanValue());
        }
        if (this.end != null) {
            generator.writeKey("end");
            this.end.serialize(generator, mapper);
        }
        if (this.page != null) {
            generator.writeKey("page");
            this.page.serialize(generator, mapper);
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.write(this.sort);
        }
        if (this.start != null) {
            generator.writeKey("start");
            this.start.serialize(generator, mapper);
        }
    }

    protected static void setupGetModelSnapshotsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::desc, JsonpDeserializer.booleanDeserializer(), "desc");
        op.add(Builder::end, DateTime._DESERIALIZER, "end");
        op.add(Builder::page, Page._DESERIALIZER, "page");
        op.add(Builder::sort, JsonpDeserializer.stringDeserializer(), "sort");
        op.add(Builder::start, DateTime._DESERIALIZER, "start");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetModelSnapshotsRequest> {
        @Nullable
        private Boolean desc;
        @Nullable
        private DateTime end;
        @Nullable
        private Integer from;
        private String jobId;
        @Nullable
        private Page page;
        @Nullable
        private Integer size;
        @Nullable
        private String snapshotId;
        @Nullable
        private String sort;
        @Nullable
        private DateTime start;

        public final Builder desc(@Nullable Boolean value) {
            this.desc = value;
            return this;
        }

        public final Builder end(@Nullable DateTime value) {
            this.end = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder page(@Nullable Page value) {
            this.page = value;
            return this;
        }

        public final Builder page(Function<Page.Builder, ObjectBuilder<Page>> fn) {
            return this.page(fn.apply(new Page.Builder()).build());
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder snapshotId(@Nullable String value) {
            this.snapshotId = value;
            return this;
        }

        public final Builder sort(@Nullable String value) {
            this.sort = value;
            return this;
        }

        public final Builder start(@Nullable DateTime value) {
            this.start = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetModelSnapshotsRequest build() {
            this._checkSingleUse();
            return new GetModelSnapshotsRequest(this);
        }
    }
}

