/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto.convert.selector;

import java.util.Objects;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;

public final class MotanUpstream
extends CommonUpstream {
    private String registerAddress;
    private String registerProtocol;

    private MotanUpstream(Builder builder) {
        boolean statusValue = builder.statusValue;
        if (!builder.statusSet) {
            statusValue = MotanUpstream.defaultStatus();
        }
        this.setUpstreamHost(builder.upstreamHost);
        this.setProtocol(builder.protocol);
        this.setUpstreamUrl(builder.upstreamUrl);
        this.setStatus(statusValue);
        this.setTimestamp(builder.timestamp);
        this.setRegisterAddress(builder.registerAddress);
        this.setRegisterProtocol(builder.registerProtocol);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRegisterAddress() {
        return this.registerAddress;
    }

    public void setRegisterAddress(String registerAddress) {
        this.registerAddress = registerAddress;
    }

    public String getRegisterProtocol() {
        return this.registerProtocol;
    }

    public void setRegisterProtocol(String registerProtocol) {
        this.registerProtocol = registerProtocol;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MotanUpstream)) {
            return false;
        }
        MotanUpstream that = (MotanUpstream)o;
        return Objects.equals(this.registerAddress, that.registerAddress) && Objects.equals(this.getProtocol(), that.getProtocol()) && Objects.equals(this.getUpstreamUrl(), that.getUpstreamUrl()) && Objects.equals(this.isGray(), that.isGray()) && Objects.equals(this.registerProtocol, that.registerProtocol);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.registerAddress, this.registerProtocol, this.isGray());
    }

    @Override
    public String toString() {
        return "MotanUpstream{registerAddress='" + this.registerAddress + ", registerProtocol=" + this.registerProtocol + "', protocol='" + this.getProtocol() + ", upstreamUrl='" + this.getUpstreamUrl() + "', gray=" + this.isGray() + ", status=" + this.isStatus() + ", timestamp=" + this.getTimestamp() + "'}";
    }

    public static final class Builder {
        private String upstreamHost;
        private String protocol;
        private String upstreamUrl;
        private boolean statusSet;
        private boolean statusValue;
        private long timestamp;
        private String registerAddress;
        private String registerProtocol;

        private Builder() {
        }

        public MotanUpstream build() {
            return new MotanUpstream(this);
        }

        public Builder upstreamHost(String upstreamHost) {
            this.upstreamHost = upstreamHost;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder upstreamUrl(String upstreamUrl) {
            this.upstreamUrl = upstreamUrl;
            return this;
        }

        public Builder status(boolean status) {
            this.statusValue = status;
            this.statusSet = true;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder registerAddress(String registerAddress) {
            this.registerAddress = registerAddress;
            return this;
        }

        public Builder registerProtocol(String registerProtocol) {
            this.registerProtocol = registerProtocol;
            return this;
        }
    }
}

