/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.AttributeUtils;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Code;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.FieldOrMethod;
import org.aspectj.apache.bcel.classfile.LineNumberTable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisParamAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisParamAnnos;
import org.aspectj.apache.bcel.generic.Type;

public final class Method
extends FieldOrMethod {
    public static final AnnotationGen[][] NO_PARAMETER_ANNOTATIONS = new AnnotationGen[0][];
    public static final Method[] NoMethods = new Method[0];
    private boolean parameterAnnotationsOutOfDate = true;
    private AnnotationGen[][] unpackedParameterAnnotations;

    private Method() {
        this.parameterAnnotationsOutOfDate = true;
    }

    public Method(Method method) {
        super(method);
        this.parameterAnnotationsOutOfDate = true;
    }

    Method(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        super(dataInputStream, constantPool);
    }

    public Method(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        super(n, n2, n3, attributeArray, constantPool);
        this.parameterAnnotationsOutOfDate = true;
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitMethod(this);
    }

    @Override
    public void setAttributes(Attribute[] attributeArray) {
        this.parameterAnnotationsOutOfDate = true;
        super.setAttributes(attributeArray);
    }

    public final Code getCode() {
        return AttributeUtils.getCodeAttribute(this.attributes);
    }

    public final ExceptionTable getExceptionTable() {
        return AttributeUtils.getExceptionTableAttribute(this.attributes);
    }

    public final LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLocalVariableTable();
        }
        return null;
    }

    public final LineNumberTable getLineNumberTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLineNumberTable();
        }
        return null;
    }

    public final String toString() {
        Object object;
        String string = Utility.accessToString(this.modifiers);
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.signatureIndex, (byte)1);
        String string2 = constantUtf8.getValue();
        constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.nameIndex, (byte)1);
        String string3 = constantUtf8.getValue();
        string2 = Utility.methodSignatureToString(string2, string3, string, true, this.getLocalVariableTable());
        StringBuffer stringBuffer = new StringBuffer(string2);
        for (int i = 0; i < this.attributes.length; ++i) {
            object = this.attributes[i];
            if (object instanceof Code || object instanceof ExceptionTable) continue;
            stringBuffer.append(" [" + ((Attribute)object).toString() + "]");
        }
        ExceptionTable exceptionTable = this.getExceptionTable();
        if (exceptionTable != null && !((String)(object = exceptionTable.toString())).equals("")) {
            stringBuffer.append("\n\t\tthrows " + (String)object);
        }
        return stringBuffer.toString();
    }

    public Type getReturnType() {
        return Type.getReturnType(this.getSignature());
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.getSignature());
    }

    private void ensureParameterAnnotationsUnpacked() {
        Cloneable cloneable;
        int n;
        if (!this.parameterAnnotationsOutOfDate) {
            return;
        }
        this.parameterAnnotationsOutOfDate = false;
        int n2 = this.getArgumentTypes().length;
        if (n2 == 0) {
            this.unpackedParameterAnnotations = NO_PARAMETER_ANNOTATIONS;
            return;
        }
        RuntimeVisParamAnnos runtimeVisParamAnnos = null;
        RuntimeInvisParamAnnos runtimeInvisParamAnnos = null;
        Attribute[] attributeArray = this.getAttributes();
        for (n = 0; n < attributeArray.length; ++n) {
            cloneable = attributeArray[n];
            if (cloneable instanceof RuntimeVisParamAnnos) {
                runtimeVisParamAnnos = (RuntimeVisParamAnnos)cloneable;
                continue;
            }
            if (!(cloneable instanceof RuntimeInvisParamAnnos)) continue;
            runtimeInvisParamAnnos = (RuntimeInvisParamAnnos)cloneable;
        }
        n = 0;
        if (runtimeInvisParamAnnos != null || runtimeVisParamAnnos != null) {
            cloneable = new ArrayList();
            AnnotationGen[] annotationGenArray = null;
            AnnotationGen[] annotationGenArray2 = null;
            for (int i = 0; i < n2; ++i) {
                int n3 = 0;
                annotationGenArray = new AnnotationGen[]{};
                annotationGenArray2 = new AnnotationGen[]{};
                if (runtimeVisParamAnnos != null) {
                    annotationGenArray = runtimeVisParamAnnos.getAnnotationsOnParameter(i);
                    n3 += annotationGenArray.length;
                }
                if (runtimeInvisParamAnnos != null) {
                    annotationGenArray2 = runtimeInvisParamAnnos.getAnnotationsOnParameter(i);
                    n3 += annotationGenArray2.length;
                }
                AnnotationGen[] annotationGenArray3 = AnnotationGen.NO_ANNOTATIONS;
                if (n3 != 0) {
                    annotationGenArray3 = new AnnotationGen[annotationGenArray.length + annotationGenArray2.length];
                    System.arraycopy(annotationGenArray, 0, annotationGenArray3, 0, annotationGenArray.length);
                    System.arraycopy(annotationGenArray2, 0, annotationGenArray3, annotationGenArray.length, annotationGenArray2.length);
                    n = 1;
                }
                cloneable.add(annotationGenArray3);
            }
            if (n != 0) {
                this.unpackedParameterAnnotations = (AnnotationGen[][])cloneable.toArray((T[])new AnnotationGen[0][]);
                return;
            }
        }
        this.unpackedParameterAnnotations = NO_PARAMETER_ANNOTATIONS;
    }

    public AnnotationGen[] getAnnotationsOnParameter(int n) {
        this.ensureParameterAnnotationsUnpacked();
        if (this.unpackedParameterAnnotations == NO_PARAMETER_ANNOTATIONS) {
            return AnnotationGen.NO_ANNOTATIONS;
        }
        return this.unpackedParameterAnnotations[n];
    }

    public AnnotationGen[][] getParameterAnnotations() {
        this.ensureParameterAnnotationsUnpacked();
        return this.unpackedParameterAnnotations;
    }
}

