/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.service.statistics;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobExecutionType;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.statistics.StatisticInterval;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobExecutionTypeStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobRegisterStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobRunningStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.task.TaskResultStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.task.TaskRunningStatistics;
import org.apache.shardingsphere.elasticjob.cloud.ui.repository.StatisticRdbRepository;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.statistics.util.StatisticTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class StatisticManager {
    private static final Logger log = LoggerFactory.getLogger(StatisticManager.class);
    @Autowired
    private CloudJobConfigurationService configurationService;
    @Autowired
    private StatisticRdbRepository rdbRepository;

    private boolean isRdbConfigured() {
        return this.rdbRepository.isEnable();
    }

    public TaskResultStatistics getTaskResultStatisticsWeekly() {
        if (!this.isRdbConfigured()) {
            return new TaskResultStatistics(0, 0, StatisticInterval.DAY, new Date());
        }
        return this.rdbRepository.getSummedTaskResultStatistics(StatisticTimeUtils.getStatisticTime(StatisticInterval.DAY, -7), StatisticInterval.DAY);
    }

    public TaskResultStatistics getTaskResultStatisticsSinceOnline() {
        if (!this.isRdbConfigured()) {
            return new TaskResultStatistics(0, 0, StatisticInterval.DAY, new Date());
        }
        return this.rdbRepository.getSummedTaskResultStatistics(this.getOnlineDate(), StatisticInterval.DAY);
    }

    public TaskResultStatistics findLatestTaskResultStatistics(StatisticInterval statisticInterval) {
        Optional<TaskResultStatistics> result;
        if (this.isRdbConfigured() && (result = this.rdbRepository.findLatestTaskResultStatistics(statisticInterval)).isPresent()) {
            return result.get();
        }
        return new TaskResultStatistics(0, 0, statisticInterval, new Date());
    }

    public List<TaskResultStatistics> findTaskResultStatisticsDaily() {
        if (!this.isRdbConfigured()) {
            return Collections.emptyList();
        }
        return this.rdbRepository.findTaskResultStatistics(StatisticTimeUtils.getStatisticTime(StatisticInterval.HOUR, -24), StatisticInterval.MINUTE);
    }

    public JobExecutionTypeStatistics getJobExecutionTypeStatistics() {
        int transientJobCnt = 0;
        int daemonJobCnt = 0;
        for (CloudJobConfigurationPOJO each : this.configurationService.loadAll()) {
            if (CloudJobExecutionType.TRANSIENT.equals((Object)each.getJobExecutionType())) {
                ++transientJobCnt;
                continue;
            }
            if (!CloudJobExecutionType.DAEMON.equals((Object)each.getJobExecutionType())) continue;
            ++daemonJobCnt;
        }
        return new JobExecutionTypeStatistics(transientJobCnt, daemonJobCnt);
    }

    public List<TaskRunningStatistics> findTaskRunningStatisticsWeekly() {
        if (!this.isRdbConfigured()) {
            return Collections.emptyList();
        }
        return this.rdbRepository.findTaskRunningStatistics(StatisticTimeUtils.getStatisticTime(StatisticInterval.DAY, -7));
    }

    public List<JobRunningStatistics> findJobRunningStatisticsWeekly() {
        if (!this.isRdbConfigured()) {
            return Collections.emptyList();
        }
        return this.rdbRepository.findJobRunningStatistics(StatisticTimeUtils.getStatisticTime(StatisticInterval.DAY, -7));
    }

    public List<JobRegisterStatistics> findJobRegisterStatisticsSinceOnline() {
        if (!this.isRdbConfigured()) {
            return Collections.emptyList();
        }
        return this.rdbRepository.findJobRegisterStatistics(this.getOnlineDate());
    }

    private Date getOnlineDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return formatter.parse("2016-12-16");
        }
        catch (ParseException ex) {
            return null;
        }
    }
}

