/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.tenantcontrol.impl;

import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.tenantcontrol.impl.TenantControlServiceImpl;
import com.hazelcast.spi.tenantcontrol.TenantControl;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class TenantControlReplicationOperation
extends Operation
implements IdentifiedDataSerializable {
    private ConcurrentMap<String, ConcurrentMap<String, TenantControl>> tenantControlMap;
    private String distributedObjectServiceName;
    private String distributedObjectName;
    private TenantControl tenantControl;

    public TenantControlReplicationOperation() {
    }

    public TenantControlReplicationOperation(@Nonnull String distributedObjectServiceName, @Nonnull String distributedObjectName, @Nonnull TenantControl tenantControl) {
        this.distributedObjectServiceName = distributedObjectServiceName;
        this.distributedObjectName = distributedObjectName;
        this.tenantControl = tenantControl;
    }

    public TenantControlReplicationOperation(@Nonnull ConcurrentMap<String, ConcurrentMap<String, TenantControl>> tenantControlMap) {
        this.tenantControlMap = tenantControlMap;
    }

    @Override
    public void run() {
        TenantControlServiceImpl service = this.getNodeEngine().getTenantControlService();
        if (this.tenantControlMap != null) {
            this.tenantControlMap.forEach((serviceName, objectMap) -> objectMap.forEach((objectName, tenantControl) -> service.appendTenantControl((String)serviceName, (String)objectName, (TenantControl)tenantControl)));
        } else {
            service.appendTenantControl(this.distributedObjectServiceName, this.distributedObjectName, this.tenantControl);
        }
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        int serviceCount = in.readInt();
        this.tenantControlMap = MapUtil.createConcurrentHashMap(serviceCount);
        for (int i = 0; i < serviceCount; ++i) {
            String serviceName = in.readString();
            int objectCount = in.readInt();
            ConcurrentMap objectMap = MapUtil.createConcurrentHashMap(objectCount);
            this.tenantControlMap.put(serviceName, objectMap);
            for (int j = 0; j < objectCount; ++j) {
                objectMap.put(in.readString(), in.readObject());
            }
        }
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        if (this.tenantControlMap != null) {
            out.writeInt(this.tenantControlMap.size());
            for (Map.Entry serviceEntry : this.tenantControlMap.entrySet()) {
                String serviceName = (String)serviceEntry.getKey();
                ConcurrentMap tenantControlPerObject = (ConcurrentMap)serviceEntry.getValue();
                out.writeString(serviceName);
                out.writeInt(tenantControlPerObject.size());
                for (Map.Entry objectEntry : tenantControlPerObject.entrySet()) {
                    out.writeString((String)objectEntry.getKey());
                    out.writeObject(objectEntry.getValue());
                }
            }
        } else {
            out.writeInt(1);
            out.writeString(this.distributedObjectServiceName);
            out.writeInt(1);
            out.writeString(this.distributedObjectName);
            out.writeObject(this.tenantControl);
        }
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 26;
    }
}

