/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.wan.impl.WanDataSerializerHook;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WanMapEntryView<K, V>
implements EntryView<K, V>,
IdentifiedDataSerializable,
SerializationServiceAware {
    private SerializationService serializationService;
    private K key;
    private V value;
    private Data dataKey;
    private Data dataValue;
    private Data trimmedDataKey;
    private Data trimmedDataValue;
    private long cost;
    private long creationTime;
    private long expirationTime;
    private long hits;
    private long lastAccessTime;
    private long lastStoredTime;
    private long lastUpdateTime;
    private long version;
    private long ttl;
    private long maxIdle;

    public WanMapEntryView() {
    }

    public WanMapEntryView(@Nonnull Data dataKey, @Nullable Data dataValue, @Nonnull SerializationService serializationService) {
        Preconditions.checkNotNull(dataKey);
        Preconditions.checkNotNull(serializationService);
        this.dataKey = serializationService.toDataWithSchema(dataKey);
        this.dataValue = serializationService.toDataWithSchema(dataValue);
        this.serializationService = serializationService;
    }

    @Override
    public K getKey() {
        if (this.key == null) {
            this.key = this.serializationService.toObject(this.dataKey);
        }
        return this.key;
    }

    public Data getDataKey() {
        if (this.trimmedDataKey == null) {
            this.trimmedDataKey = this.serializationService.trimSchema(this.dataKey);
        }
        return this.trimmedDataKey;
    }

    @Override
    public V getValue() {
        if (this.value == null) {
            this.value = this.serializationService.toObject(this.dataValue);
        }
        return this.value;
    }

    public Data getDataValue() {
        if (this.trimmedDataValue == null) {
            this.trimmedDataValue = this.serializationService.trimSchema(this.dataValue);
        }
        return this.trimmedDataValue;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getLastStoredTime() {
        return this.lastStoredTime;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public long getTtl() {
        return this.ttl;
    }

    @Override
    public long getMaxIdle() {
        return this.maxIdle;
    }

    public WanMapEntryView<K, V> withCost(long cost) {
        this.cost = cost;
        return this;
    }

    public WanMapEntryView<K, V> withCreationTime(long creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public WanMapEntryView<K, V> withExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public WanMapEntryView<K, V> withHits(long hits) {
        this.hits = hits;
        return this;
    }

    public WanMapEntryView<K, V> withLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        return this;
    }

    public WanMapEntryView<K, V> withLastStoredTime(long lastStoredTime) {
        this.lastStoredTime = lastStoredTime;
        return this;
    }

    public WanMapEntryView<K, V> withLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    public WanMapEntryView<K, V> withVersion(long version) {
        this.version = version;
        return this;
    }

    public WanMapEntryView<K, V> withTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public WanMapEntryView<K, V> withMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        IOUtil.writeData(out, this.dataKey);
        IOUtil.writeData(out, this.dataValue);
        out.writeLong(this.cost);
        out.writeLong(this.creationTime);
        out.writeLong(this.expirationTime);
        out.writeLong(this.hits);
        out.writeLong(this.lastAccessTime);
        out.writeLong(this.lastStoredTime);
        out.writeLong(this.lastUpdateTime);
        out.writeLong(this.version);
        out.writeLong(this.ttl);
        out.writeLong(this.maxIdle);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.dataKey = IOUtil.readData(in);
        this.dataValue = IOUtil.readData(in);
        this.cost = in.readLong();
        this.creationTime = in.readLong();
        this.expirationTime = in.readLong();
        this.hits = in.readLong();
        this.lastAccessTime = in.readLong();
        this.lastStoredTime = in.readLong();
        this.lastUpdateTime = in.readLong();
        this.version = in.readLong();
        this.ttl = in.readLong();
        this.maxIdle = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WanMapEntryView that = (WanMapEntryView)o;
        return this.cost == that.cost && this.creationTime == that.creationTime && this.expirationTime == that.expirationTime && this.hits == that.hits && this.lastAccessTime == that.lastAccessTime && this.lastStoredTime == that.lastStoredTime && this.lastUpdateTime == that.lastUpdateTime && this.version == that.version && this.ttl == that.ttl && this.maxIdle == that.maxIdle && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && this.dataKey.equals(that.dataKey) && this.dataValue.equals(that.dataValue);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.dataKey, this.dataValue, this.cost, this.creationTime, this.expirationTime, this.hits, this.lastAccessTime, this.lastStoredTime, this.lastUpdateTime, this.version, this.ttl, this.maxIdle);
    }

    public String toString() {
        return "WanMapEntryView{dataKey=" + this.dataKey + ", key=" + this.key + ", dataValue=" + this.dataValue + ", value=" + this.value + ", cost=" + this.cost + ", creationTime=" + this.creationTime + ", expirationTime=" + this.expirationTime + ", hits=" + this.hits + ", lastAccessTime=" + this.lastAccessTime + ", lastStoredTime=" + this.lastStoredTime + ", lastUpdateTime=" + this.lastUpdateTime + ", version=" + this.version + ", ttl=" + this.ttl + ", maxIdle=" + this.maxIdle + '}';
    }

    @Override
    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }
}

