/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

class BuildInfoCollector
implements MetricsCollector {
    static final int CLASSPATH_MAX_LENGTH = 100000;
    private static final String PARDOT_ID_ENV_VAR = "HZ_PARDOT_ID";
    private final Map<String, String> envVars;

    BuildInfoCollector(Map<String, String> envVars) {
        this.envVars = envVars;
    }

    static String formatClassPath(String classpath) {
        String[] classPathEntries = classpath.split(File.pathSeparator);
        String shortenedEntries = Arrays.stream(classPathEntries).filter(cpEntry -> cpEntry.endsWith(".jar")).map(cpEntry -> cpEntry.substring(cpEntry.lastIndexOf(File.separator) + 1)).collect(Collectors.joining(","));
        return shortenedEntries.substring(0, Math.min(100000, shortenedEntries.length()));
    }

    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer) {
        BuildInfo imdgInfo = node.getBuildInfo();
        metricsConsumer.accept(PhoneHomeMetrics.HAZELCAST_DOWNLOAD_ID, this.getDownloadId());
        metricsConsumer.accept(PhoneHomeMetrics.JAVA_VERSION_OF_SYSTEM, System.getProperty("java.version"));
        metricsConsumer.accept(PhoneHomeMetrics.BUILD_VERSION, imdgInfo.getVersion());
        String classpath = System.getProperty("java.class.path");
        if (classpath != null) {
            metricsConsumer.accept(PhoneHomeMetrics.JAVA_CLASSPATH, BuildInfoCollector.formatClassPath(classpath));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDownloadId() {
        String passedByEnvVar = this.envVars.get(PARDOT_ID_ENV_VAR);
        if (passedByEnvVar != null) {
            return passedByEnvVar;
        }
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("hazelcast-download.properties");){
            if (is == null) return "source";
            Properties properties = new Properties();
            properties.load(is);
            String string = properties.getProperty("hazelcastDownloadId");
            return string;
        }
        catch (IOException ignored) {
            EmptyStatement.ignore(ignored);
        }
        return "source";
    }
}

