/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.fasterxml.jackson.jr.ob.impl;

import com.hazelcast.com.fasterxml.jackson.core.TreeNode;
import com.hazelcast.com.fasterxml.jackson.jr.ob.JSON;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.UUID;

abstract class ValueLocatorBase {
    public static final int SER_UNKNOWN = 0;
    public static final int SER_MAP = 1;
    public static final int SER_LIST = 2;
    public static final int SER_COLLECTION = 3;
    public static final int SER_OBJECT_ARRAY = 4;
    public static final int SER_INT_ARRAY = 5;
    public static final int SER_LONG_ARRAY = 6;
    public static final int SER_BOOLEAN_ARRAY = 7;
    public static final int SER_TREE_NODE = 8;
    public static final int SER_STRING = 9;
    public static final int SER_CHARACTER_SEQUENCE = 10;
    public static final int SER_CHAR_ARRAY = 11;
    public static final int SER_BYTE_ARRAY = 12;
    public static final int SER_NUMBER_BYTE = 13;
    public static final int SER_NUMBER_SHORT = 14;
    public static final int SER_NUMBER_INTEGER = 15;
    public static final int SER_NUMBER_LONG = 16;
    public static final int SER_NUMBER_FLOAT = 17;
    public static final int SER_NUMBER_DOUBLE = 18;
    public static final int SER_NUMBER_BIG_INTEGER = 19;
    public static final int SER_NUMBER_BIG_DECIMAL = 20;
    public static final int SER_BOOLEAN = 21;
    public static final int SER_CHAR = 22;
    public static final int SER_ENUM = 23;
    public static final int SER_DATE = 24;
    public static final int SER_CALENDAR = 25;
    public static final int SER_CLASS = 26;
    public static final int SER_FILE = 27;
    public static final int SER_UUID = 28;
    public static final int SER_URL = 29;
    public static final int SER_URI = 30;
    public static final int SER_ITERABLE = 31;
    protected static final int CACHE_FLAGS = JSON.CACHE_FLAGS;

    ValueLocatorBase() {
    }

    protected int _findSimpleType(Class<?> clazz, boolean bl) {
        if (clazz == String.class) {
            return 9;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                if (clazz == byte[].class) {
                    return 12;
                }
                if (clazz == char[].class) {
                    return 11;
                }
                if (clazz == int[].class) {
                    return 5;
                }
                if (clazz == long[].class) {
                    return 6;
                }
                if (clazz == boolean[].class) {
                    return 7;
                }
                return 0;
            }
            return 4;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return 21;
            }
            if (clazz == Integer.TYPE) {
                return 15;
            }
            if (clazz == Long.TYPE) {
                return 16;
            }
            if (clazz == Byte.TYPE) {
                return 13;
            }
            if (clazz == Short.TYPE) {
                return 14;
            }
            if (clazz == Double.TYPE) {
                return 18;
            }
            if (clazz == Float.TYPE) {
                return 17;
            }
            if (clazz == Character.TYPE) {
                return 22;
            }
            throw new IllegalArgumentException("Unrecognized primitive type: " + clazz.getName());
        }
        if (clazz == Boolean.class) {
            return 21;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if (clazz == Integer.class) {
                return 15;
            }
            if (clazz == Long.class) {
                return 16;
            }
            if (clazz == Byte.class) {
                return 13;
            }
            if (clazz == Short.class) {
                return 14;
            }
            if (clazz == Double.class) {
                return 18;
            }
            if (clazz == Float.class) {
                return 17;
            }
            if (clazz == BigDecimal.class) {
                return 20;
            }
            if (clazz == BigInteger.class) {
                return 19;
            }
            return 0;
        }
        if (clazz == Character.class) {
            return 22;
        }
        if (clazz.isEnum()) {
            return 23;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (List.class.isAssignableFrom(clazz) && RandomAccess.class.isAssignableFrom(clazz)) {
                return 2;
            }
            return 3;
        }
        if (TreeNode.class.isAssignableFrom(clazz)) {
            return 8;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return 25;
        }
        if (clazz == Class.class) {
            return 26;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 24;
        }
        if (File.class.isAssignableFrom(clazz)) {
            return 27;
        }
        if (URL.class.isAssignableFrom(clazz)) {
            return 29;
        }
        if (URI.class.isAssignableFrom(clazz)) {
            return 30;
        }
        if (UUID.class.isAssignableFrom(clazz)) {
            return 28;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return 10;
        }
        if (bl && Iterable.class.isAssignableFrom(clazz)) {
            return 31;
        }
        return 0;
    }
}

