/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.scheduledexecutor;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetStatsFromMemberCodec;
import com.hazelcast.client.impl.protocol.task.AbstractTargetMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.ScheduledTaskStatistics;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskHandlerImpl;
import com.hazelcast.scheduledexecutor.impl.operations.GetStatisticsOperation;
import com.hazelcast.security.permission.ScheduledExecutorPermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorTaskGetStatisticsFromTargetMessageTask
extends AbstractTargetMessageTask<ScheduledExecutorGetStatsFromMemberCodec.RequestParameters> {
    public ScheduledExecutorTaskGetStatisticsFromTargetMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Operation prepareOperation() {
        ScheduledTaskHandler handler = ScheduledTaskHandlerImpl.of(((ScheduledExecutorGetStatsFromMemberCodec.RequestParameters)this.parameters).memberUuid, ((ScheduledExecutorGetStatsFromMemberCodec.RequestParameters)this.parameters).schedulerName, ((ScheduledExecutorGetStatsFromMemberCodec.RequestParameters)this.parameters).taskName);
        return new GetStatisticsOperation(handler);
    }

    @Override
    protected UUID getTargetUuid() {
        return ((ScheduledExecutorGetStatsFromMemberCodec.RequestParameters)this.parameters).memberUuid;
    }

    @Override
    protected ScheduledExecutorGetStatsFromMemberCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ScheduledExecutorGetStatsFromMemberCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        ScheduledTaskStatistics stats = (ScheduledTaskStatistics)response;
        return ScheduledExecutorGetStatsFromMemberCodec.encodeResponse(stats.getLastIdleTime(TimeUnit.NANOSECONDS), stats.getTotalIdleTime(TimeUnit.NANOSECONDS), stats.getTotalRuns(), stats.getTotalRunTime(TimeUnit.NANOSECONDS), stats.getLastRunDuration(TimeUnit.NANOSECONDS));
    }

    @Override
    public String getServiceName() {
        return "hz:impl:scheduledExecutorService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new ScheduledExecutorPermission(((ScheduledExecutorGetStatsFromMemberCodec.RequestParameters)this.parameters).schedulerName, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return ((ScheduledExecutorGetStatsFromMemberCodec.RequestParameters)this.parameters).schedulerName;
    }

    @Override
    public String getMethodName() {
        return "getStatistics";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

