/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.semaphore;

import com.hazelcast.client.cp.internal.session.ClientProxySessionManager;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreAcquireCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreAvailablePermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreChangeCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreDrainCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreInitCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreReleaseCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.exception.WaitKeyCancelledException;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class SessionlessSemaphoreProxy
extends ClientProxy
implements ISemaphore {
    private final ClientProxySessionManager sessionManager = this.getClient().getProxySessionManager();
    private final RaftGroupId groupId;
    private final String objectName;

    public SessionlessSemaphoreProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:semaphoreService", proxyName, context);
        this.groupId = groupId;
        this.objectName = objectName;
    }

    @Override
    public boolean init(int permits) {
        Preconditions.checkNotNegative(permits, "Permits must be non-negative!");
        ClientMessage request = SemaphoreInitCodec.encodeRequest(this.groupId, this.objectName, permits);
        HazelcastClientInstanceImpl client = this.getClient();
        ClientMessage response = (ClientMessage)new ClientInvocation(client, request, this.objectName).invoke().joinInternal();
        return SemaphoreInitCodec.decodeResponse(response);
    }

    @Override
    public void acquire() {
        this.acquire(1);
    }

    @Override
    public void acquire(int permits) {
        Preconditions.checkPositive("permits", permits);
        this.doTryAcquire(permits, -1L);
    }

    @Override
    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryAcquire(int permits) {
        return this.tryAcquire(permits, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return this.tryAcquire(1, timeout, unit);
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
        Preconditions.checkPositive(permits, "Permits must be positive!");
        long timeoutMs = Math.max(0L, unit.toMillis(timeout));
        return this.doTryAcquire(permits, timeoutMs);
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        Preconditions.checkPositive(permits, "Permits must be positive!");
        long clusterWideThreadId = this.sessionManager.getOrCreateUniqueThreadId(this.groupId);
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        ClientMessage request = SemaphoreReleaseCodec.encodeRequest(this.groupId, this.objectName, -1L, clusterWideThreadId, invocationUid, permits);
        HazelcastClientInstanceImpl client = this.getClient();
        new ClientInvocation(client, request, this.objectName).invoke().joinInternal();
    }

    @Override
    public int availablePermits() {
        ClientMessage request = SemaphoreAvailablePermitsCodec.encodeRequest(this.groupId, this.objectName);
        HazelcastClientInstanceImpl client = this.getClient();
        ClientMessage response = (ClientMessage)new ClientInvocation(client, request, this.objectName).invoke().joinInternal();
        return SemaphoreAvailablePermitsCodec.decodeResponse(response);
    }

    @Override
    public int drainPermits() {
        long clusterWideThreadId = this.sessionManager.getOrCreateUniqueThreadId(this.groupId);
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        ClientMessage request = SemaphoreDrainCodec.encodeRequest(this.groupId, this.objectName, -1L, clusterWideThreadId, invocationUid);
        HazelcastClientInstanceImpl client = this.getClient();
        ClientMessage response = (ClientMessage)new ClientInvocation(client, request, this.objectName).invoke().joinInternal();
        return SemaphoreDrainCodec.decodeResponse(response);
    }

    @Override
    public void reducePermits(int reduction) {
        Preconditions.checkNotNegative(reduction, "Reduction must be non-negative!");
        if (reduction == 0) {
            return;
        }
        this.doChangePermits(-reduction);
    }

    @Override
    public void increasePermits(int increase) {
        Preconditions.checkNotNegative(increase, "Increase must be non-negative!");
        if (increase == 0) {
            return;
        }
        this.doChangePermits(increase);
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onDestroy() {
        ClientMessage request = CPGroupDestroyCPObjectCodec.encodeRequest(this.groupId, this.getServiceName(), this.objectName);
        new ClientInvocation(this.getClient(), request, this.name).invoke().joinInternal();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }

    private boolean doTryAcquire(int permits, long timeoutMs) {
        long clusterWideThreadId = this.sessionManager.getOrCreateUniqueThreadId(this.groupId);
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        ClientMessage request = SemaphoreAcquireCodec.encodeRequest(this.groupId, this.objectName, -1L, clusterWideThreadId, invocationUid, permits, timeoutMs);
        try {
            ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, this.objectName).invoke().joinInternal();
            return SemaphoreAcquireCodec.decodeResponse(response);
        }
        catch (WaitKeyCancelledException e) {
            throw new IllegalStateException("Semaphore[" + this.objectName + "] not acquired because the acquire call on the CP group is cancelled, possibly because of another indeterminate call from the same thread.");
        }
    }

    private void doChangePermits(int delta) {
        long clusterWideThreadId = this.sessionManager.getOrCreateUniqueThreadId(this.groupId);
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        ClientMessage request = SemaphoreChangeCodec.encodeRequest(this.groupId, this.objectName, -1L, clusterWideThreadId, invocationUid, delta);
        new ClientInvocation(this.getClient(), request, this.objectName).invoke().joinInternal();
    }
}

