/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dynamicforms.validate;

import com.google.common.base.Preconditions;
import java.util.List;
import lombok.NonNull;
import org.apache.seatunnel.app.dynamicforms.validate.AbstractValidate;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonProperty;

public class MutuallyExclusiveValidate
extends AbstractValidate {
    private final boolean required = false;
    private List<String> fields;
    @JsonProperty(value="type")
    private final AbstractValidate.RequiredType requiredType = AbstractValidate.RequiredType.MUTUALLY_EXCLUSIVE;

    public MutuallyExclusiveValidate(@NonNull List<String> fields) {
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        Preconditions.checkArgument((fields.size() > 0 ? 1 : 0) != 0);
        this.fields = fields;
        this.withMessage("parameters:" + fields + ", only one can be set");
    }

    public boolean isRequired() {
        return this.required;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public AbstractValidate.RequiredType getRequiredType() {
        return this.requiredType;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutuallyExclusiveValidate)) {
            return false;
        }
        MutuallyExclusiveValidate other = (MutuallyExclusiveValidate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        List<String> this$fields = this.getFields();
        List<String> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        AbstractValidate.RequiredType this$requiredType = this.getRequiredType();
        AbstractValidate.RequiredType other$requiredType = other.getRequiredType();
        return !(this$requiredType == null ? other$requiredType != null : !((Object)((Object)this$requiredType)).equals((Object)other$requiredType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MutuallyExclusiveValidate;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequired() ? 79 : 97);
        List<String> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        AbstractValidate.RequiredType $requiredType = this.getRequiredType();
        result = result * 59 + ($requiredType == null ? 43 : ((Object)((Object)$requiredType)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MutuallyExclusiveValidate(required=" + this.isRequired() + ", fields=" + this.getFields() + ", requiredType=" + (Object)((Object)this.getRequiredType()) + ")";
    }
}

