/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.transfrom.impl;

import com.google.auto.service.AutoService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.app.domain.request.job.TableSchemaReq;
import org.apache.seatunnel.app.domain.request.job.transform.ChangeOrder;
import org.apache.seatunnel.app.domain.request.job.transform.DeleteField;
import org.apache.seatunnel.app.domain.request.job.transform.FieldMapperTransformOptions;
import org.apache.seatunnel.app.domain.request.job.transform.RenameField;
import org.apache.seatunnel.app.domain.request.job.transform.Transform;
import org.apache.seatunnel.app.domain.request.job.transform.TransformOptions;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.transfrom.TransformConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.transfrom.TransformConfigSwitcherUtils;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;

@AutoService(value={TransformConfigSwitcher.class})
public class FieldMapperTransformSwitcher
implements TransformConfigSwitcher {
    @Override
    public Transform getTransform() {
        return Transform.FIELDMAPPER;
    }

    @Override
    public FormStructure getFormStructure(OptionRule transformOptionRule) {
        return null;
    }

    @Override
    public Config mergeTransformConfig(Config transformConfig, TransformOptions transformOption, TableSchemaReq inputSchema) {
        LinkedHashMap<String, String> fieldsMap = inputSchema.getFields().stream().map(TableField::getName).collect(Collectors.toMap(key -> key, key -> key, (v1, v2) -> v1, LinkedHashMap::new));
        FieldMapperTransformOptions fieldMapperTransformOptions = (FieldMapperTransformOptions)transformOption;
        List<DeleteField> deleteFields = fieldMapperTransformOptions.getDeleteFields();
        List<RenameField> renameFields = fieldMapperTransformOptions.getRenameFields();
        List<ChangeOrder> changeOrders = fieldMapperTransformOptions.getChangeOrders();
        for (RenameField renameField : renameFields) {
            if (!fieldsMap.containsKey(renameField.getSourceFieldName())) {
                throw new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{"FieldMapperTransformSwitcher renameFields sourceFieldName not exist"});
            }
            fieldsMap.put(renameField.getSourceFieldName(), renameField.getTargetName());
        }
        for (DeleteField deleteField : deleteFields) {
            if (!fieldsMap.containsKey(deleteField.getSourceFieldName())) {
                throw new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{"FieldMapperTransformSwitcher deleteFields sourceFieldName not exist"});
            }
            fieldsMap.remove(deleteField.getSourceFieldName());
        }
        for (ChangeOrder changeOrder : changeOrders) {
            if (!fieldsMap.containsKey(changeOrder.getSourceFieldName())) {
                throw new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{"FieldMapperTransformSwitcher changeOrders sourceFieldName not exist"});
            }
            fieldsMap = FieldMapperTransformSwitcher.reorderLinkedHashMap(fieldsMap, changeOrder.getSourceFieldName(), changeOrder.getIndex());
        }
        return transformConfig.withValue("field_mapper", (ConfigValue)TransformConfigSwitcherUtils.getOrderedConfigForLinkedHashMap(fieldsMap).root());
    }

    public static LinkedHashMap<String, String> reorderLinkedHashMap(LinkedHashMap<String, String> map, String key, int index) {
        if (map == null || !map.containsKey(key) || index < 0 || index >= map.size()) {
            return map;
        }
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        int currentIndex = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (currentIndex == index) {
                resultMap.put(key, map.get(key));
            }
            if (entry.getKey().equals(key)) continue;
            resultMap.put(entry.getKey(), entry.getValue());
            ++currentIndex;
        }
        if (index == map.size() - 1) {
            resultMap.put(key, map.get(key));
        }
        return resultMap;
    }
}

