/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource.impl;

import com.google.auto.service.AutoService;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.impl.BaseJdbcDataSourceConfigSwitcher;
import org.apache.seatunnel.common.utils.SeaTunnelException;

@AutoService(value={DataSourceConfigSwitcher.class})
public class OracleDataSourceConfigSwitcher
extends BaseJdbcDataSourceConfigSwitcher {
    public static final String CATALOG_NAME = "Oracle";

    @Override
    protected String tableFieldsToSql(List<String> tableFields, String database, String fullTable) {
        String[] split = fullTable.split("\\.");
        if (split.length != 2) {
            throw new SeaTunnelException("The tableName for oracle must be schemaName.tableName, but tableName is " + fullTable);
        }
        String schemaName = split[0];
        String tableName = split[1];
        return this.generateSql(tableFields, database, schemaName, tableName);
    }

    @Override
    protected String quoteIdentifier(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    protected String generateSql(List<String> tableFields, String database, String schema, String table) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (int i = 0; i < tableFields.size(); ++i) {
            sb.append(this.quoteIdentifier(tableFields.get(i)));
            if (i >= tableFields.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(" FROM ").append(this.quoteIdentifier(schema)).append(".").append(this.quoteIdentifier(table));
        return sb.toString();
    }

    @Override
    public String getDataSourceName() {
        return "JDBC-ORACLE";
    }

    @Override
    protected boolean isSupportDefaultSchema() {
        return true;
    }

    @Override
    protected Optional<String> getCatalogName() {
        return Optional.of(CATALOG_NAME);
    }
}

