/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dal.dao.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.app.dal.dao.TaskDefinitionDao;
import org.apache.seatunnel.app.dal.entity.ProcessTaskRelation;
import org.apache.seatunnel.app.dal.entity.TaskDefinition;
import org.apache.seatunnel.app.dal.entity.TaskMainInfo;
import org.apache.seatunnel.app.dal.mapper.ProcessTaskRelationMapper;
import org.apache.seatunnel.app.dal.mapper.TaskDefinitionMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskDefinitionDaoImpl
implements TaskDefinitionDao {
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;

    @Override
    public List<TaskMainInfo> queryByDataSourceId(Long dataSourceId) {
        return this.processTaskRelationMapper.queryByDataSourceId(dataSourceId);
    }

    @Override
    public List<TaskDefinition> queryTaskDefinitions(Collection<Long> taskCodes) {
        if (CollectionUtils.isEmpty(taskCodes)) {
            return Collections.emptyList();
        }
        return this.taskDefinitionMapper.queryByCodeList(taskCodes);
    }

    @Override
    public List<TaskDefinition> queryByWorkflowDefinitionCodeAndVersion(Long workflowDefinitionCode, Integer workflowDefinitionVersion) {
        List<ProcessTaskRelation> processTaskRelations = this.processTaskRelationMapper.queryProcessTaskRelationsByProcessDefinitionCode(workflowDefinitionCode, workflowDefinitionVersion);
        HashSet<Long> taskCodes = new HashSet<Long>();
        processTaskRelations.forEach(processTaskRelation -> {
            taskCodes.add(processTaskRelation.getPreTaskCode());
            taskCodes.add(processTaskRelation.getPostTaskCode());
        });
        if (CollectionUtils.isEmpty(taskCodes)) {
            return Collections.emptyList();
        }
        return this.taskDefinitionMapper.queryByCodeList(taskCodes);
    }
}

