/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.controller;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.controller.BaseController;
import org.apache.seatunnel.app.dal.dao.IUserDao;
import org.apache.seatunnel.app.dal.entity.User;
import org.apache.seatunnel.app.domain.request.datasource.VirtualTableReq;
import org.apache.seatunnel.app.domain.response.PageInfo;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableRes;
import org.apache.seatunnel.app.service.IVirtualTableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/seatunnel/api/v1/virtual_table"})
public class VirtualTableController
extends BaseController {
    @Autowired
    private IVirtualTableService virtualTableService;
    @Resource(name="userDaoImpl")
    private IUserDao userMapper;

    @ApiOperation(value="create virtual table", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableReq", value="virtual table request", required=true, dataType="VirtualTableReq")})
    @PostMapping(value={"/create"})
    Result<String> createVirtualTable(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestBody VirtualTableReq tableReq) {
        return Result.success(this.virtualTableService.createVirtualTable(loginUser.getId(), tableReq));
    }

    @ApiOperation(value="update virtual table", httpMethod="PUT")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="virtual table id", required=true, dataType="String"), @ApiImplicitParam(name="tableReq", value="virtual table request", required=true, dataType="VirtualTableReq")})
    @PutMapping(value={"/{id}"})
    Result<Boolean> updateVirtualTable(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") String id, @RequestBody VirtualTableReq tableReq) {
        return Result.success(this.virtualTableService.updateVirtualTable(loginUser.getId(), id, tableReq));
    }

    @ApiOperation(value="check virtual table valid", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="virtualTableReq", value="virtual table request", required=true, dataType="VirtualTableReq")})
    @GetMapping(value={"/check/valid"})
    Result<Boolean> checkVirtualTableValid(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestBody VirtualTableReq virtualTableReq) {
        return Result.success(this.virtualTableService.checkVirtualTableValid(virtualTableReq));
    }

    @ApiOperation(value="get support field type", httpMethod="GET")
    @GetMapping(value={"/support/field_type"})
    Result<List<String>> getSupportFieldType(@RequestParam(value="pluginName") String pluginName) {
        return null;
    }

    @ApiOperation(value="delete virtual table", httpMethod="DELETE")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="virtual table id", required=true, dataType="String")})
    @DeleteMapping(value={"/{id}"})
    Result<Boolean> deleteVirtualTable(@PathVariable(value="id") String id, @ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        return Result.success(this.virtualTableService.deleteVirtualTable(loginUser.getId(), id));
    }

    @ApiOperation(value="query virtual table detail by id", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="virtual table id", required=true, dataType="String")})
    @GetMapping(value={"/{id}"})
    Result<VirtualTableDetailRes> queryVirtualTable(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") String id) {
        return Result.success(this.virtualTableService.queryVirtualTable(id));
    }

    @GetMapping(value={"/list"})
    Result<PageInfo<VirtualTableRes>> getVirtualTableList(@RequestParam(value="pluginName") String pluginName, @RequestParam(value="datasourceName") String datasourceName, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        PageInfo<VirtualTableRes> virtualTableList = this.virtualTableService.getVirtualTableList(pluginName, datasourceName, pageNo, pageSize);
        if (virtualTableList.getTotalCount() == 0 || CollectionUtils.isEmpty(virtualTableList.getData())) {
            return Result.success(virtualTableList);
        }
        Map<Integer, String> userIdNameMap = this.userIdNameMap();
        virtualTableList.getData().forEach(virtualTableRes -> {
            virtualTableRes.setCreateUserName(userIdNameMap.getOrDefault(virtualTableRes.getCreateUserId(), ""));
            virtualTableRes.setUpdateUserName(userIdNameMap.getOrDefault(virtualTableRes.getUpdateUserId(), ""));
        });
        return Result.success(virtualTableList);
    }

    @GetMapping(value={"/dynamic_config"})
    Result<String> getDynamicConfig(@RequestParam(value="pluginName") String pluginName, @RequestParam(value="datasourceName") String datasourceName) {
        return Result.success(this.virtualTableService.queryTableDynamicTable(pluginName));
    }

    public Map<Integer, String> userIdNameMap() {
        return this.userMapper.queryEnabledUsers().stream().collect(Collectors.toMap(User::getId, User::getUsername));
    }
}

