/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.config;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.DefaultPropertySourceFactory;
import org.springframework.core.io.support.EncodedResource;

public class YamlSourceFactory
extends DefaultPropertySourceFactory {
    public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
        if (resource == null) {
            return super.createPropertySource(name, resource);
        }
        Resource resourceResource = resource.getResource();
        if (!resourceResource.exists()) {
            return new PropertiesPropertySource(null, new Properties());
        }
        if (resourceResource.getFilename().endsWith(".yml") || resourceResource.getFilename().endsWith(".yaml")) {
            List sources = new YamlPropertySourceLoader().load(resourceResource.getFilename(), resourceResource);
            return (PropertySource)sources.get(0);
        }
        return super.createPropertySource(name, resource);
    }
}

