/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.datasource.classloader.DatasourceLoadConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(DatasourceClassLoader.class);
    private final ClassLoader parentClassLoader;

    public DatasourceClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, (ClassLoader)null);
        this.parentClassLoader = parent;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        log.info("load class for name : " + name);
        try {
            for (String alwaysParentFirstPattern : DatasourceLoadConfig.DEFAULT_PARENT_FIRST_PATTERNS) {
                if (!name.startsWith(alwaysParentFirstPattern)) continue;
                return this.parentClassLoader.loadClass(name);
            }
            return this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            log.info("load class from parentClassLoader : " + name);
            try {
                return this.parentClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException superE) {
                log.error("parentClassLoader load class is error : " + ExceptionUtils.getMessage(e));
                throw new ClassNotFoundException("parentClassLoader Failed to load class: " + name, superE);
            }
        }
    }

    @Override
    public URL getResource(String name) {
        URL urlClassLoaderResource = this.findResource(name);
        if (urlClassLoaderResource != null) {
            return urlClassLoaderResource;
        }
        return this.parentClassLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urlClassLoaderResources = this.findResources(name);
        final ArrayList<URL> result2 = new ArrayList<URL>();
        while (urlClassLoaderResources.hasMoreElements()) {
            result2.add(urlClassLoaderResources.nextElement());
        }
        if (this.parentClassLoader != null) {
            Enumeration<URL> parentResources = this.parentClassLoader.getResources(name);
            while (parentResources.hasMoreElements()) {
                result2.add(parentResources.nextElement());
            }
        }
        return new Enumeration<URL>(){
            final Iterator<URL> iter;
            {
                this.iter = result2.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }
}

