/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.utils;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.text.StrSubstitutor;

public final class VariablesSubstitute {
    private VariablesSubstitute() {
    }

    public static String substitute(String text, String timeFormat) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(timeFormat);
        String formattedDate = df.format(ZonedDateTime.now());
        HashMap<String, String> valuesMap = new HashMap<String, String>(3);
        valuesMap.put("uuid", UUID.randomUUID().toString());
        valuesMap.put("now", formattedDate);
        valuesMap.put(timeFormat, formattedDate);
        return VariablesSubstitute.substitute(text, valuesMap);
    }

    public static String substitute(String text, Map<String, String> valuesMap) {
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(text);
    }
}

