/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.event;

import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.event.AlterTableColumnEvent;

public class AlterTableAddColumnEvent
extends AlterTableColumnEvent {
    private final Column column;
    private final boolean first;
    private final String afterColumn;

    public AlterTableAddColumnEvent(TablePath tablePath, Column column, boolean first, String afterColumn) {
        super(tablePath);
        this.column = column;
        this.first = first;
        this.afterColumn = afterColumn;
    }

    public static AlterTableAddColumnEvent addFirst(TablePath tablePath, Column column) {
        return new AlterTableAddColumnEvent(tablePath, column, true, null);
    }

    public static AlterTableAddColumnEvent add(TablePath tablePath, Column column) {
        return new AlterTableAddColumnEvent(tablePath, column, false, null);
    }

    public static AlterTableAddColumnEvent addAfter(TablePath tablePath, Column column, String afterColumn) {
        return new AlterTableAddColumnEvent(tablePath, column, false, afterColumn);
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean isFirst() {
        return this.first;
    }

    public String getAfterColumn() {
        return this.afterColumn;
    }

    @Override
    public String toString() {
        return "AlterTableAddColumnEvent(super=" + super.toString() + ", column=" + this.getColumn() + ", first=" + this.isFirst() + ", afterColumn=" + this.getAfterColumn() + ")";
    }
}

