/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import java.util.Map;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public abstract class Column
implements Serializable {
    private static final long serialVersionUID = -1L;
    protected final String name;
    protected final SeaTunnelDataType<?> dataType;
    protected final Integer columnLength;
    protected final boolean nullable;
    protected final Object defaultValue;
    protected final String comment;
    protected final String sourceType;
    protected final boolean isUnsigned;
    protected final boolean isZeroFill;
    protected final Long bitLen;
    protected final Long longColumnLength;
    protected final Map<String, Object> options;

    protected Column(String name, SeaTunnelDataType<?> dataType, Integer columnLength, boolean nullable, Object defaultValue, String comment) {
        this(name, dataType, columnLength, nullable, defaultValue, comment, null, false, false, null, 0L, null);
    }

    protected Column(String name, SeaTunnelDataType<?> dataType, Integer columnLength, boolean nullable, Object defaultValue, String comment, String sourceType, boolean isUnsigned, boolean isZeroFill, Long bitLen, Long longColumnLength, Map<String, Object> options) {
        this.name = name;
        this.dataType = dataType;
        this.columnLength = columnLength;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.comment = comment;
        this.sourceType = sourceType;
        this.isUnsigned = isUnsigned;
        this.isZeroFill = isZeroFill;
        this.bitLen = bitLen;
        this.longColumnLength = longColumnLength;
        this.options = options;
    }

    public abstract boolean isPhysical();

    public abstract Column copy(SeaTunnelDataType<?> var1);

    public abstract Column copy();

    public String getName() {
        return this.name;
    }

    public SeaTunnelDataType<?> getDataType() {
        return this.dataType;
    }

    public Integer getColumnLength() {
        return this.columnLength;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getComment() {
        return this.comment;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isZeroFill() {
        return this.isZeroFill;
    }

    public Long getBitLen() {
        return this.bitLen;
    }

    public Long getLongColumnLength() {
        return this.longColumnLength;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNullable() != other.isNullable()) {
            return false;
        }
        if (this.isUnsigned() != other.isUnsigned()) {
            return false;
        }
        if (this.isZeroFill() != other.isZeroFill()) {
            return false;
        }
        Integer this$columnLength = this.getColumnLength();
        Integer other$columnLength = other.getColumnLength();
        if (this$columnLength == null ? other$columnLength != null : !((Object)this$columnLength).equals(other$columnLength)) {
            return false;
        }
        Long this$bitLen = this.getBitLen();
        Long other$bitLen = other.getBitLen();
        if (this$bitLen == null ? other$bitLen != null : !((Object)this$bitLen).equals(other$bitLen)) {
            return false;
        }
        Long this$longColumnLength = this.getLongColumnLength();
        Long other$longColumnLength = other.getLongColumnLength();
        if (this$longColumnLength == null ? other$longColumnLength != null : !((Object)this$longColumnLength).equals(other$longColumnLength)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        SeaTunnelDataType<?> this$dataType = this.getDataType();
        SeaTunnelDataType<?> other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        Map<String, Object> this$options = this.getOptions();
        Map<String, Object> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Column;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + (this.isNullable() ? 79 : 97);
        result2 = result2 * 59 + (this.isUnsigned() ? 79 : 97);
        result2 = result2 * 59 + (this.isZeroFill() ? 79 : 97);
        Integer $columnLength = this.getColumnLength();
        result2 = result2 * 59 + ($columnLength == null ? 43 : ((Object)$columnLength).hashCode());
        Long $bitLen = this.getBitLen();
        result2 = result2 * 59 + ($bitLen == null ? 43 : ((Object)$bitLen).hashCode());
        Long $longColumnLength = this.getLongColumnLength();
        result2 = result2 * 59 + ($longColumnLength == null ? 43 : ((Object)$longColumnLength).hashCode());
        String $name = this.getName();
        result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
        SeaTunnelDataType<?> $dataType = this.getDataType();
        result2 = result2 * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        Object $defaultValue = this.getDefaultValue();
        result2 = result2 * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $comment = this.getComment();
        result2 = result2 * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $sourceType = this.getSourceType();
        result2 = result2 * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        Map<String, Object> $options = this.getOptions();
        result2 = result2 * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result2;
    }

    public String toString() {
        return "Column(name=" + this.getName() + ", dataType=" + this.getDataType() + ", columnLength=" + this.getColumnLength() + ", nullable=" + this.isNullable() + ", defaultValue=" + this.getDefaultValue() + ", comment=" + this.getComment() + ", sourceType=" + this.getSourceType() + ", isUnsigned=" + this.isUnsigned() + ", isZeroFill=" + this.isZeroFill() + ", bitLen=" + this.getBitLen() + ", longColumnLength=" + this.getLongColumnLength() + ", options=" + this.getOptions() + ")";
    }
}

