/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.replace;

import com.google.auto.service.AutoService;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.ConfigValidator;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.transform.common.SeaTunnelRowAccessor;
import org.apache.seatunnel.transform.common.SingleFieldOutputTransform;
import org.apache.seatunnel.transform.replace.ReplaceTransformConfig;
import org.apache.seatunnel.transform.replace.ReplaceTransformFactory;

@AutoService(value={SeaTunnelTransform.class})
public class ReplaceTransform
extends SingleFieldOutputTransform {
    private ReadonlyConfig config;
    private int inputFieldIndex;

    public ReplaceTransform(@NonNull ReadonlyConfig config, @NonNull CatalogTable inputCatalogTable) {
        super(inputCatalogTable);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (inputCatalogTable == null) {
            throw new NullPointerException("inputCatalogTable is marked non-null but is null");
        }
        this.config = config;
        this.initOutputFields(inputCatalogTable.getTableSchema().toPhysicalRowDataType(), (String)this.config.get(ReplaceTransformConfig.KEY_REPLACE_FIELD));
    }

    public String getPluginName() {
        return "Replace";
    }

    @Override
    protected void setConfig(Config pluginConfig) {
        ConfigValidator.of((ReadonlyConfig)ReadonlyConfig.fromConfig((Config)pluginConfig)).validate(new ReplaceTransformFactory().optionRule());
        this.config = ReadonlyConfig.fromConfig((Config)pluginConfig);
    }

    @Override
    protected void setInputRowType(SeaTunnelRowType rowType) {
        this.initOutputFields(rowType, (String)this.config.get(ReplaceTransformConfig.KEY_REPLACE_FIELD));
    }

    private void initOutputFields(SeaTunnelRowType inputRowType, String replaceField) {
        this.inputFieldIndex = inputRowType.indexOf(replaceField);
        if (this.inputFieldIndex == -1) {
            throw new IllegalArgumentException("Cannot find [" + replaceField + "] field in input row type");
        }
    }

    @Override
    protected String getOutputFieldName() {
        return (String)this.config.get(ReplaceTransformConfig.KEY_REPLACE_FIELD);
    }

    @Override
    protected SeaTunnelDataType getOutputFieldDataType() {
        return BasicType.STRING_TYPE;
    }

    @Override
    protected Object getOutputFieldValue(SeaTunnelRowAccessor inputRow) {
        boolean isRegex;
        Object inputFieldValue = inputRow.getField(this.inputFieldIndex);
        if (inputFieldValue == null) {
            return null;
        }
        boolean bl = isRegex = this.config.get(ReplaceTransformConfig.KEY_IS_REGEX) == null ? false : (Boolean)this.config.get(ReplaceTransformConfig.KEY_IS_REGEX);
        if (isRegex) {
            if (((Boolean)this.config.get(ReplaceTransformConfig.KEY_REPLACE_FIRST)).booleanValue()) {
                return inputFieldValue.toString().replaceFirst((String)this.config.get(ReplaceTransformConfig.KEY_PATTERN), (String)this.config.get(ReplaceTransformConfig.KEY_REPLACEMENT));
            }
            return inputFieldValue.toString().replaceAll((String)this.config.get(ReplaceTransformConfig.KEY_PATTERN), (String)this.config.get(ReplaceTransformConfig.KEY_REPLACEMENT));
        }
        return inputFieldValue.toString().replace((CharSequence)this.config.get(ReplaceTransformConfig.KEY_PATTERN), (CharSequence)this.config.get(ReplaceTransformConfig.KEY_REPLACEMENT));
    }

    @Override
    protected Column getOutputColumn() {
        List columns = this.inputCatalogTable.getTableSchema().getColumns();
        List collect = columns.stream().filter(column -> column.getName().equals(this.config.get(ReplaceTransformConfig.KEY_REPLACE_FIELD))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            throw new IllegalArgumentException("Cannot find [" + (String)this.config.get(ReplaceTransformConfig.KEY_REPLACE_FIELD) + "] field in input catalog table");
        }
        return ((Column)collect.get(0)).copy();
    }

    public ReplaceTransform() {
    }
}

