/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.command;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Strings;
import com.beust.jcommander.UnixStyleUsageFormatter;
import com.beust.jcommander.WrappedParameter;
import java.util.List;

public class UsageFormatter
extends UnixStyleUsageFormatter {
    private static final int INDENT = 3;

    public UsageFormatter(JCommander commander) {
        super(commander);
    }

    public void appendAllParametersDetails(StringBuilder out, int indentCount, String indent, List<ParameterDescription> sortedParameters) {
        String prefix;
        WrappedParameter parameter;
        if (sortedParameters.size() > 0) {
            out.append(indent).append("  Options:\n");
        }
        int prefixIndent = 0;
        for (ParameterDescription pd : sortedParameters) {
            parameter = pd.getParameter();
            prefix = (parameter.required() ? "* " : "  ") + pd.getNames();
            if (prefix.length() <= prefixIndent) continue;
            prefixIndent = prefix.length();
        }
        for (ParameterDescription pd : sortedParameters) {
            parameter = pd.getParameter();
            prefix = (parameter.required() ? "* " : "  ") + pd.getNames();
            out.append(indent).append("  ").append(prefix).append(UsageFormatter.s((int)(prefixIndent - prefix.length()))).append(" ");
            int initialLinePrefixLength = indent.length() + prefixIndent + 3;
            String description = pd.getDescription();
            Object def = pd.getDefault();
            if (pd.isDynamicParameter()) {
                String syntax = "(syntax: " + parameter.names()[0] + "key" + parameter.getAssignment() + "value)";
                description = description + (description.length() == 0 ? "" : " ") + syntax;
            }
            Class type = pd.getParameterized().getType();
            if (def != null && !pd.isHelp()) {
                String displayText = type.isEnum() ? def.toString().toLowerCase() : def.toString();
                String displayedDef = Strings.isStringEmpty((String)displayText) ? "<empty string>" : displayText;
                String defaultText = "(default: " + (parameter.password() ? "********" : displayedDef) + ")";
                description = description + (description.length() == 0 ? "" : " ") + defaultText;
            }
            this.wrapDescription(out, indentCount + prefixIndent - 3, initialLinePrefixLength, description);
            out.append("\n");
        }
    }
}

