/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.util;

import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.engine.core.job.JobStatusData;

public class ContentFormatUtil {
    public static String format(List<JobStatusData> jobStatusDataList) {
        int maxJobIdLength = 6;
        int maxJobNameLength = 8;
        int maxJobStatusLength = 10;
        int maxSubmitTimeLength = 23;
        int maxFinishTimeLength = 23;
        for (JobStatusData jobStatusData : jobStatusDataList) {
            maxJobIdLength = Math.max(maxJobIdLength, String.valueOf(jobStatusData.getJobId()).length());
            maxJobNameLength = Math.max(maxJobNameLength, String.valueOf(jobStatusData.getJobName()).length());
            maxJobStatusLength = Math.max(maxJobStatusLength, String.valueOf(jobStatusData.getJobStatus()).length());
        }
        String formatStr = "%-" + (maxJobIdLength + 2) + "s%-" + (maxJobNameLength + 2) + "s%-" + (maxJobStatusLength + 2) + "s%-" + (maxSubmitTimeLength + 2) + "s%-" + (maxFinishTimeLength + 2) + "s";
        String header = String.format(formatStr, "Job ID", "Job Name", "Job Status", "Submit Time", "Finished Time");
        String separator = String.format(formatStr, StringUtils.repeat((String)"-", (int)maxJobIdLength), StringUtils.repeat((String)"-", (int)maxJobNameLength), StringUtils.repeat((String)"-", (int)maxJobStatusLength), StringUtils.repeat((String)"-", (int)maxSubmitTimeLength), StringUtils.repeat((String)"-", (int)maxFinishTimeLength));
        StringBuilder sb = new StringBuilder();
        for (JobStatusData jobStatusData : jobStatusDataList) {
            String jobId = String.format("%-" + maxJobIdLength + "s", jobStatusData.getJobId());
            String jobName = String.format("%-" + maxJobNameLength + "s", jobStatusData.getJobName());
            String jobStatus = String.format("%-" + maxJobStatusLength + "s", jobStatusData.getJobStatus());
            String submitTime = String.format("%-" + maxSubmitTimeLength + "s", new Timestamp(jobStatusData.getSubmitTime()));
            String finishTime = "";
            if (jobStatusData.getFinishTime() != null) {
                finishTime = String.format("%-" + maxFinishTimeLength + "s", new Timestamp(jobStatusData.getFinishTime()));
            }
            sb.append(jobId).append("  ").append(jobName).append("  ").append(jobStatus).append("  ").append(submitTime).append("  ").append(finishTime).append("\n");
        }
        return header + "\n" + separator + "\n" + sb;
    }
}

