/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.persistence;

import com.google.common.collect.Maps;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.MapLoaderLifecycleSupport;
import com.hazelcast.map.MapStore;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.seatunnel.engine.common.utils.FactoryUtil;
import org.apache.seatunnel.engine.imap.storage.api.IMapStorage;
import org.apache.seatunnel.engine.imap.storage.api.IMapStorageFactory;

public class FileMapStore
implements MapStore<Object, Object>,
MapLoaderLifecycleSupport {
    private IMapStorage mapStorage;

    @Override
    public void init(HazelcastInstance hazelcastInstance, Properties properties, String mapName) {
        HashMap<String, Object> initMap = new HashMap<String, Object>(Maps.fromProperties(properties));
        this.mapStorage = FactoryUtil.discoverFactory(Thread.currentThread().getContextClassLoader(), IMapStorageFactory.class, (String)initMap.get("type")).create(initMap);
    }

    @Override
    public void destroy() {
        this.mapStorage.destroy(false);
    }

    @Override
    public void store(Object key, Object value) {
        this.mapStorage.store(key, value);
    }

    @Override
    public void storeAll(Map<Object, Object> map) {
        this.mapStorage.storeAll(map);
    }

    @Override
    public void delete(Object key) {
        this.mapStorage.delete(key);
    }

    @Override
    public void deleteAll(Collection<Object> keys) {
        this.mapStorage.deleteAll(keys);
    }

    @Override
    public Object load(Object key) {
        return null;
    }

    @Override
    public Map<Object, Object> loadAll(Collection<Object> keys) {
        Map<Object, Object> allMap = this.mapStorage.loadAll();
        HashMap retMap = new HashMap();
        keys.forEach(key -> retMap.put(key, allMap.get(key)));
        return Collections.unmodifiableMap(retMap);
    }

    @Override
    public Iterable<Object> loadAllKeys() {
        return this.mapStorage.loadAllKeys();
    }
}

