/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.engine.checkpoint.storage.PipelineState;
import org.apache.seatunnel.engine.checkpoint.storage.api.CheckpointStorage;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.checkpoint.CheckpointIDCounter;
import org.apache.seatunnel.engine.core.checkpoint.CheckpointType;
import org.apache.seatunnel.engine.serializer.api.Serializer;
import org.apache.seatunnel.engine.serializer.protobuf.ProtoStuffSerializer;
import org.apache.seatunnel.engine.server.checkpoint.ActionState;
import org.apache.seatunnel.engine.server.checkpoint.ActionStateKey;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointBarrier;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCloseReason;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCoordinatorState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCoordinatorStatus;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointException;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointManager;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointPlan;
import org.apache.seatunnel.engine.server.checkpoint.CompletedCheckpoint;
import org.apache.seatunnel.engine.server.checkpoint.PendingCheckpoint;
import org.apache.seatunnel.engine.server.checkpoint.SubtaskStatus;
import org.apache.seatunnel.engine.server.checkpoint.TaskStatistics;
import org.apache.seatunnel.engine.server.checkpoint.operation.CheckpointBarrierTriggerOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.CheckpointEndOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.CheckpointFinishedOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.NotifyTaskRestoreOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.NotifyTaskStartOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskAcknowledgeOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskReportStatusOperation;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.task.record.Barrier;
import org.apache.seatunnel.engine.server.task.statemachine.SeaTunnelTaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointCoordinator.class);
    private final long jobId;
    private final int pipelineId;
    private final CheckpointManager checkpointManager;
    private final CheckpointStorage checkpointStorage;
    private final CheckpointIDCounter checkpointIdCounter;
    private final transient Serializer serializer;
    private final Map<Long, Integer> pipelineTasks;
    private final Map<Long, SeaTunnelTaskState> pipelineTaskStatus;
    private final CheckpointPlan plan;
    private final Set<TaskLocation> readyToCloseStartingTask;
    private final ConcurrentHashMap<Long, PendingCheckpoint> pendingCheckpoints;
    private final ArrayDeque<String> completedCheckpointIds;
    private volatile CompletedCheckpoint latestCompletedCheckpoint = null;
    private final CheckpointConfig coordinatorConfig;
    private transient ScheduledExecutorService scheduler;
    private final AtomicLong latestTriggerTimestamp = new AtomicLong(0L);
    private final AtomicInteger pendingCounter = new AtomicInteger(0);
    private final AtomicBoolean schemaChanging = new AtomicBoolean(false);
    private final Object lock = new Object();
    private volatile boolean shutdown;
    private volatile boolean isAllTaskReady = false;
    private final ExecutorService executorService;
    private CompletableFuture<CheckpointCoordinatorState> checkpointCoordinatorFuture;
    private AtomicReference<String> errorByPhysicalVertex = new AtomicReference();
    private final IMap<Object, Object> runningJobStateIMap;
    private PendingCheckpoint savepointPendingCheckpoint;
    private final String checkpointStateImapKey;

    public CheckpointCoordinator(CheckpointManager manager, CheckpointStorage checkpointStorage, CheckpointConfig checkpointConfig, long jobId, CheckpointPlan plan, CheckpointIDCounter checkpointIdCounter, PipelineState pipelineState, ExecutorService executorService, IMap<Object, Object> runningJobStateIMap, boolean isStartWithSavePoint) {
        this.executorService = executorService;
        this.checkpointManager = manager;
        this.checkpointStorage = checkpointStorage;
        this.jobId = jobId;
        this.pipelineId = plan.getPipelineId();
        this.checkpointStateImapKey = "checkpoint_state_" + jobId + "_" + this.pipelineId;
        this.runningJobStateIMap = runningJobStateIMap;
        this.plan = plan;
        this.coordinatorConfig = checkpointConfig;
        this.pendingCheckpoints = new ConcurrentHashMap();
        this.completedCheckpointIds = new ArrayDeque(this.coordinatorConfig.getStorage().getMaxRetainedCheckpoints() + 1);
        this.scheduler = Executors.newScheduledThreadPool(2, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName(String.format("checkpoint-coordinator-%s/%s", this.pipelineId, jobId));
            return thread;
        });
        ((ScheduledThreadPoolExecutor)this.scheduler).setRemoveOnCancelPolicy(true);
        this.serializer = new ProtoStuffSerializer();
        this.pipelineTasks = CheckpointCoordinator.getPipelineTasks(plan.getPipelineSubtasks());
        this.pipelineTaskStatus = new ConcurrentHashMap<Long, SeaTunnelTaskState>();
        this.checkpointIdCounter = checkpointIdCounter;
        this.readyToCloseStartingTask = new CopyOnWriteArraySet<TaskLocation>();
        LOG.info("Create CheckpointCoordinator for job({}@{}) with plan({})", this.pipelineId, jobId, plan);
        if (pipelineState != null) {
            this.latestCompletedCheckpoint = this.serializer.deserialize(pipelineState.getStates(), CompletedCheckpoint.class);
            this.latestCompletedCheckpoint.setRestored(true);
            LOG.info("Restore job({}@{}) with checkpoint({}), data: {}", this.pipelineId, jobId, this.latestCompletedCheckpoint.getCheckpointId(), this.latestCompletedCheckpoint);
        }
        this.checkpointCoordinatorFuture = new CompletableFuture();
        CheckpointCoordinatorStatus checkpointCoordinatorStatus = (CheckpointCoordinatorStatus)((Object)runningJobStateIMap.get(this.checkpointStateImapKey));
        if (isStartWithSavePoint) {
            this.updateStatus(CheckpointCoordinatorStatus.RUNNING);
            return;
        }
        if (checkpointCoordinatorStatus != null) {
            if (checkpointCoordinatorStatus.isEndState()) {
                this.checkpointCoordinatorFuture.complete(new CheckpointCoordinatorState(checkpointCoordinatorStatus, null));
            } else {
                this.updateStatus(CheckpointCoordinatorStatus.RUNNING);
            }
        }
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    protected void reportedTask(TaskReportStatusOperation operation) {
        this.pipelineTaskStatus.put(operation.getLocation().getTaskID(), operation.getStatus());
        CompletableFuture.runAsync(() -> {
            switch (operation.getStatus()) {
                case WAITING_RESTORE: {
                    this.restoreTaskState(operation.getLocation());
                    break;
                }
                case READY_START: {
                    this.allTaskReady();
                    break;
                }
            }
        }, this.executorService).exceptionally(error -> {
            this.handleCoordinatorError("task running failed", (Throwable)error, CheckpointCloseReason.CHECKPOINT_INSIDE_ERROR);
            return null;
        });
    }

    @VisibleForTesting
    public void handleCoordinatorError(String message, Throwable e, CheckpointCloseReason reason) {
        LOG.error(message, e);
        this.handleCoordinatorError(reason, e);
    }

    private void handleCoordinatorError(CheckpointCloseReason reason, Throwable e) {
        CheckpointException checkpointException = new CheckpointException(reason, e);
        this.errorByPhysicalVertex.compareAndSet(null, ExceptionUtils.getMessage(checkpointException));
        if (this.checkpointCoordinatorFuture.isDone()) {
            return;
        }
        this.cleanPendingCheckpoint(reason);
        this.updateStatus(CheckpointCoordinatorStatus.FAILED);
        this.checkpointCoordinatorFuture.complete(new CheckpointCoordinatorState(CheckpointCoordinatorStatus.FAILED, this.errorByPhysicalVertex.get()));
        this.checkpointManager.handleCheckpointError(this.pipelineId, false);
    }

    private void restoreTaskState(TaskLocation taskLocation) {
        ArrayList<ActionSubtaskState> states = new ArrayList<ActionSubtaskState>();
        if (this.latestCompletedCheckpoint != null) {
            Integer currentParallelism = this.pipelineTasks.get(taskLocation.getTaskVertexId());
            this.plan.getSubtaskActions().get(taskLocation).forEach(tuple -> {
                ActionState actionState = this.latestCompletedCheckpoint.getTaskStates().get(tuple.f0());
                if (actionState == null) {
                    LOG.info("Not found task({}) state for key({})", (Object)taskLocation, tuple.f0());
                    return;
                }
                if (CheckpointPlan.COORDINATOR_INDEX.equals(tuple.f1())) {
                    states.add(actionState.getCoordinatorState());
                    return;
                }
                for (int i = ((Integer)tuple.f1()).intValue(); i < actionState.getParallelism(); i += currentParallelism.intValue()) {
                    states.add(actionState.getSubtaskStates().get(i));
                }
            });
        }
        this.checkpointManager.sendOperationToMemberNode(new NotifyTaskRestoreOperation(taskLocation, states)).join();
    }

    private void allTaskReady() {
        if (this.pipelineTaskStatus.size() != this.plan.getPipelineSubtasks().size()) {
            return;
        }
        for (SeaTunnelTaskState status : this.pipelineTaskStatus.values()) {
            if (SeaTunnelTaskState.READY_START == status) continue;
            return;
        }
        this.isAllTaskReady = true;
        InvocationFuture<?>[] futures = this.notifyTaskStart();
        CompletableFuture.allOf(futures).join();
        this.notifyCompleted(this.latestCompletedCheckpoint);
        if (this.coordinatorConfig.isCheckpointEnable()) {
            LOG.info("checkpoint is enabled, start schedule trigger pending checkpoint.");
            this.scheduleTriggerPendingCheckpoint(this.coordinatorConfig.getCheckpointInterval());
        } else {
            LOG.info("checkpoint is disabled, because in batch mode and 'checkpoint.interval' of env is missing.");
        }
    }

    private void notifyCompleted(CompletedCheckpoint completedCheckpoint) {
        if (completedCheckpoint != null) {
            try {
                LOG.info("start notify checkpoint completed, job id: {}, pipeline id: {}, checkpoint id:{}", completedCheckpoint.getJobId(), completedCheckpoint.getPipelineId(), completedCheckpoint.getCheckpointId());
                InvocationFuture<?>[] invocationFutures = this.notifyCheckpointCompleted(completedCheckpoint);
                CompletableFuture.allOf(invocationFutures).join();
                InvocationFuture<?>[] invocationFuturesForEnd = this.notifyCheckpointEnd(completedCheckpoint);
                CompletableFuture.allOf(invocationFuturesForEnd).join();
            }
            catch (Throwable e) {
                this.handleCoordinatorError("notify checkpoint completed failed", e, CheckpointCloseReason.CHECKPOINT_NOTIFY_COMPLETE_FAILED);
            }
        }
    }

    public InvocationFuture<?>[] notifyTaskStart() {
        return (InvocationFuture[])this.plan.getPipelineSubtasks().stream().map(NotifyTaskStartOperation::new).map(this.checkpointManager::sendOperationToMemberNode).toArray(InvocationFuture[]::new);
    }

    public void reportCheckpointErrorFromTask(String errorMsg) {
        this.handleCoordinatorError("report error from task", new SeaTunnelException(errorMsg), CheckpointCloseReason.CHECKPOINT_INSIDE_ERROR);
    }

    private void scheduleTriggerPendingCheckpoint(long delayMills) {
        this.scheduleTriggerPendingCheckpoint(CheckpointType.CHECKPOINT_TYPE, delayMills);
    }

    private void scheduleTriggerPendingCheckpoint(CheckpointType checkpointType, long delayMills) {
        this.scheduler.schedule(() -> this.tryTriggerPendingCheckpoint(checkpointType), delayMills, TimeUnit.MILLISECONDS);
    }

    protected void readyToClose(TaskLocation taskLocation) {
        this.readyToCloseStartingTask.add(taskLocation);
        if (this.readyToCloseStartingTask.size() == this.plan.getStartingSubtasks().size()) {
            this.tryTriggerPendingCheckpoint(CheckpointType.COMPLETED_POINT_TYPE);
        }
    }

    protected void restoreCoordinator(boolean alreadyStarted) {
        LOG.info("received restore CheckpointCoordinator with alreadyStarted= " + alreadyStarted);
        this.errorByPhysicalVertex = new AtomicReference();
        this.checkpointCoordinatorFuture = new CompletableFuture();
        this.updateStatus(CheckpointCoordinatorStatus.RUNNING);
        this.cleanPendingCheckpoint(CheckpointCloseReason.CHECKPOINT_COORDINATOR_RESET);
        this.shutdown = false;
        if (alreadyStarted) {
            this.isAllTaskReady = true;
            this.notifyCompleted(this.latestCompletedCheckpoint);
            this.tryTriggerPendingCheckpoint(CheckpointType.CHECKPOINT_TYPE);
        } else {
            this.isAllTaskReady = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryTriggerPendingCheckpoint(CheckpointType checkpointType) {
        if (Thread.currentThread().isInterrupted()) {
            LOG.warn("currentThread already be interrupted, skip trigger checkpoint");
            return;
        }
        long currentTimestamp = Instant.now().toEpochMilli();
        if (checkpointType.notFinalCheckpoint() && checkpointType.notSchemaChangeCheckpoint() && (currentTimestamp - this.latestTriggerTimestamp.get() < this.coordinatorConfig.getCheckpointInterval() || !this.isAllTaskReady)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isCompleted() || this.isShutdown()) {
                LOG.warn(String.format("can't trigger checkpoint with type: %s, because checkpoint coordinator already have last completed checkpoint: (%s) or shutdown (%b).", new Object[]{checkpointType, this.latestCompletedCheckpoint != null ? this.latestCompletedCheckpoint.getCheckpointType() : "null", this.shutdown}));
                return;
            }
            if (this.schemaChanging.get() && checkpointType.isGeneralCheckpoint()) {
                LOG.info("skip trigger generic-checkpoint because schema change in progress");
                return;
            }
            if (this.pendingCounter.get() > 0) {
                this.scheduleTriggerPendingCheckpoint(checkpointType, 500L);
                LOG.debug("skip trigger checkpoint because there is already a pending checkpoint.");
                return;
            }
            CompletableFuture<PendingCheckpoint> pendingCheckpoint = this.createPendingCheckpoint(currentTimestamp, checkpointType);
            this.startTriggerPendingCheckpoint(pendingCheckpoint);
            if (checkpointType.notFinalCheckpoint() && checkpointType.notSchemaChangeCheckpoint()) {
                this.scheduleTriggerPendingCheckpoint(this.coordinatorConfig.getCheckpointInterval());
            }
        }
    }

    private boolean isShutdown() {
        return this.shutdown;
    }

    public static Map<Long, Integer> getPipelineTasks(Set<TaskLocation> pipelineSubtasks) {
        return pipelineSubtasks.stream().collect(Collectors.groupingBy(TaskLocation::getTaskVertexId, Collectors.toList())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PassiveCompletableFuture<CompletedCheckpoint> startSavepoint() {
        CompletableFuture<PendingCheckpoint> savepoint;
        LOG.info(String.format("Start save point for Job (%s)", this.jobId));
        if (this.shutdown || this.isCompleted()) {
            return this.completableFutureWithError(CheckpointCloseReason.CHECKPOINT_COORDINATOR_SHUTDOWN);
        }
        if (!this.isAllTaskReady) {
            return this.completableFutureWithError(CheckpointCloseReason.TASK_NOT_ALL_READY_WHEN_SAVEPOINT);
        }
        if (this.savepointPendingCheckpoint != null && !this.savepointPendingCheckpoint.getCompletableFuture().isDone()) {
            return this.savepointPendingCheckpoint.getCompletableFuture();
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.pendingCounter.get() > 0 && !this.shutdown) {
                Thread.sleep(500L);
            }
            if (this.shutdown || this.isCompleted()) {
                return this.completableFutureWithError(CheckpointCloseReason.CHECKPOINT_COORDINATOR_SHUTDOWN);
            }
            savepoint = this.createPendingCheckpoint(Instant.now().toEpochMilli(), CheckpointType.SAVEPOINT_TYPE);
            this.startTriggerPendingCheckpoint(savepoint);
        }
        this.savepointPendingCheckpoint = savepoint.join();
        LOG.info(String.format("The save point checkpointId is %s", this.savepointPendingCheckpoint.getCheckpointId()));
        return this.savepointPendingCheckpoint.getCompletableFuture();
    }

    private PassiveCompletableFuture<CompletedCheckpoint> completableFutureWithError(CheckpointCloseReason closeReason) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new CheckpointException(closeReason));
        return new PassiveCompletableFuture<CompletedCheckpoint>(future);
    }

    private void startTriggerPendingCheckpoint(CompletableFuture<PendingCheckpoint> pendingCompletableFuture) {
        pendingCompletableFuture.thenAccept(pendingCheckpoint -> {
            LOG.info("wait checkpoint completed: " + pendingCheckpoint.getCheckpointId());
            PassiveCompletableFuture<CompletedCheckpoint> completableFuture = pendingCheckpoint.getCompletableFuture();
            completableFuture.whenCompleteAsync((completedCheckpoint, error) -> {
                if (error != null) {
                    this.handleCoordinatorError("trigger checkpoint failed", (Throwable)error, CheckpointCloseReason.CHECKPOINT_INSIDE_ERROR);
                } else if (completedCheckpoint != null) {
                    try {
                        this.completePendingCheckpoint((CompletedCheckpoint)completedCheckpoint);
                    }
                    catch (Throwable e) {
                        this.handleCoordinatorError("complete checkpoint failed", e, CheckpointCloseReason.CHECKPOINT_INSIDE_ERROR);
                    }
                } else {
                    LOG.info("skip this checkpoint cause by completedCheckpoint is null");
                }
            }, (Executor)this.executorService);
            LOG.debug("trigger checkpoint barrier {}", (Object)pendingCheckpoint.getInfo());
            CompletionStage completableFutureArray = CompletableFuture.supplyAsync(() -> new CheckpointBarrier(pendingCheckpoint.getCheckpointId(), pendingCheckpoint.getCheckpointTimestamp(), pendingCheckpoint.getCheckpointType()), this.executorService).thenApplyAsync(this::triggerCheckpoint, (Executor)this.executorService);
            try {
                CompletableFuture.allOf(new CompletableFuture[]{completableFutureArray}).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                LOG.error(ExceptionUtils.getMessage(e));
                return;
            }
            if (this.coordinatorConfig.isCheckpointEnable()) {
                LOG.debug("Start a scheduled task to prevent checkpoint timeouts for barrier " + pendingCheckpoint.getInfo());
                long checkpointTimeout = this.coordinatorConfig.getCheckpointTimeout();
                if (pendingCheckpoint.getCheckpointType().isSchemaChangeAfterCheckpoint()) {
                    checkpointTimeout = this.coordinatorConfig.getSchemaChangeCheckpointTimeout();
                }
                pendingCheckpoint.setCheckpointTimeOutFuture(this.scheduler.schedule(() -> {
                    if (this.pendingCheckpoints.get(pendingCheckpoint.getCheckpointId()) != null && !pendingCheckpoint.isFullyAcknowledged()) {
                        LOG.info("timeout checkpoint: " + pendingCheckpoint.getInfo());
                        this.handleCoordinatorError(CheckpointCloseReason.CHECKPOINT_EXPIRED, null);
                    }
                }, checkpointTimeout, TimeUnit.MILLISECONDS));
            }
        });
        this.pendingCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<PendingCheckpoint> createPendingCheckpoint(long triggerTimestamp, CheckpointType checkpointType) {
        Object object = this.lock;
        synchronized (object) {
            CompletableFuture<Long> idFuture = checkpointType.notCompletedCheckpoint() ? CompletableFuture.supplyAsync(() -> {
                try {
                    return this.checkpointIdCounter.getAndIncrement();
                }
                catch (Throwable e) {
                    this.handleCoordinatorError("get checkpoint id failed", e, CheckpointCloseReason.CHECKPOINT_INSIDE_ERROR);
                    throw new CompletionException(e);
                }
            }, this.executorService) : CompletableFuture.supplyAsync(() -> Barrier.PREPARE_CLOSE_BARRIER_ID, this.executorService);
            return this.triggerPendingCheckpoint(triggerTimestamp, idFuture, checkpointType);
        }
    }

    private CompletableFuture<PendingCheckpoint> triggerPendingCheckpoint(long triggerTimestamp, CompletableFuture<Long> idFuture, CheckpointType checkpointType) {
        if (!Thread.holdsLock(this.lock)) {
            throw new RuntimeException(String.format("Unsafe invoke, the current thread[%s] has not acquired the lock[%s].", Thread.currentThread().getName(), this.lock.toString()));
        }
        this.latestTriggerTimestamp.set(triggerTimestamp);
        return ((CompletableFuture)idFuture.thenApplyAsync(checkpointId -> new PendingCheckpoint(this.jobId, this.plan.getPipelineId(), (long)checkpointId, triggerTimestamp, checkpointType, this.getNotYetAcknowledgedTasks(), this.getTaskStatistics(), this.getActionStates()), (Executor)this.executorService)).thenApplyAsync(pendingCheckpoint -> {
            this.pendingCheckpoints.put(pendingCheckpoint.getCheckpointId(), (PendingCheckpoint)pendingCheckpoint);
            return pendingCheckpoint;
        }, (Executor)this.executorService);
    }

    private Set<Long> getNotYetAcknowledgedTasks() {
        return this.plan.getPipelineSubtasks().stream().map(TaskLocation::getTaskID).collect(Collectors.toCollection(CopyOnWriteArraySet::new));
    }

    private Map<ActionStateKey, ActionState> getActionStates() {
        return this.plan.getPipelineActions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ActionState((ActionStateKey)entry.getKey(), (Integer)entry.getValue())));
    }

    private Map<Long, TaskStatistics> getTaskStatistics() {
        return this.pipelineTasks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new TaskStatistics((Long)entry.getKey(), (Integer)entry.getValue())));
    }

    public InvocationFuture<?>[] triggerCheckpoint(CheckpointBarrier checkpointBarrier) {
        return (InvocationFuture[])this.plan.getStartingSubtasks().stream().map(taskLocation -> new CheckpointBarrierTriggerOperation(checkpointBarrier, (TaskLocation)taskLocation)).map(this.checkpointManager::sendOperationToMemberNode).toArray(InvocationFuture[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanPendingCheckpoint(CheckpointCloseReason closedReason) {
        this.shutdown = true;
        this.isAllTaskReady = false;
        Object object = this.lock;
        synchronized (object) {
            LOG.info("start clean pending checkpoint cause {}", (Object)closedReason.message());
            if (!this.pendingCheckpoints.isEmpty()) {
                this.pendingCheckpoints.values().forEach(pendingCheckpoint -> pendingCheckpoint.abortCheckpoint(closedReason, null));
                this.pendingCheckpoints.clear();
            }
            this.pipelineTaskStatus.clear();
            this.readyToCloseStartingTask.clear();
            this.pendingCounter.set(0);
            this.schemaChanging.set(false);
            this.scheduler.shutdownNow();
            this.scheduler = Executors.newScheduledThreadPool(2, runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName(String.format("checkpoint-coordinator-%s/%s", this.pipelineId, this.jobId));
                return thread;
            });
        }
    }

    protected void acknowledgeTask(TaskAcknowledgeOperation ackOperation) {
        long checkpointId = ackOperation.getBarrier().getId();
        PendingCheckpoint pendingCheckpoint = this.pendingCheckpoints.get(checkpointId);
        if (pendingCheckpoint == null) {
            LOG.info("skip already ack checkpoint " + checkpointId);
            return;
        }
        TaskLocation location = ackOperation.getTaskLocation();
        LOG.debug("task[{}]({}/{}) ack. {}", location.getTaskID(), location.getPipelineId(), location.getJobId(), ackOperation.getBarrier().toString());
        pendingCheckpoint.acknowledgeTask(location, ackOperation.getStates(), pendingCheckpoint.getCheckpointType().isSavepoint() ? SubtaskStatus.SAVEPOINT_PREPARE_CLOSE : SubtaskStatus.RUNNING);
    }

    public synchronized void completePendingCheckpoint(CompletedCheckpoint completedCheckpoint) {
        LOG.debug("pending checkpoint({}/{}@{}) completed! cost: {}, trigger: {}, completed: {}", completedCheckpoint.getCheckpointId(), completedCheckpoint.getPipelineId(), completedCheckpoint.getJobId(), completedCheckpoint.getCompletedTimestamp() - completedCheckpoint.getCheckpointTimestamp(), completedCheckpoint.getCheckpointTimestamp(), completedCheckpoint.getCompletedTimestamp());
        long checkpointId = completedCheckpoint.getCheckpointId();
        this.completedCheckpointIds.addLast(String.valueOf(completedCheckpoint.getCheckpointId()));
        try {
            byte[] states = this.serializer.serialize(completedCheckpoint);
            this.checkpointStorage.storeCheckPoint(PipelineState.builder().checkpointId(checkpointId).jobId(String.valueOf(this.jobId)).pipelineId(this.pipelineId).states(states).build());
            if (this.completedCheckpointIds.size() % this.coordinatorConfig.getStorage().getMaxRetainedCheckpoints() == 0 && this.completedCheckpointIds.size() / this.coordinatorConfig.getStorage().getMaxRetainedCheckpoints() > 1) {
                ArrayList<String> needDeleteCheckpointId = new ArrayList<String>();
                for (int i = 0; i < this.coordinatorConfig.getStorage().getMaxRetainedCheckpoints(); ++i) {
                    needDeleteCheckpointId.add(this.completedCheckpointIds.removeFirst());
                }
                this.checkpointStorage.deleteCheckpoint(String.valueOf(completedCheckpoint.getJobId()), String.valueOf(completedCheckpoint.getPipelineId()), needDeleteCheckpointId);
            }
        }
        catch (Throwable e) {
            LOG.error("store checkpoint states failed.", e);
            ExceptionUtil.sneakyThrow(e);
        }
        LOG.info("pending checkpoint({}/{}@{}) notify finished!", completedCheckpoint.getCheckpointId(), completedCheckpoint.getPipelineId(), completedCheckpoint.getJobId());
        this.latestCompletedCheckpoint = completedCheckpoint;
        this.notifyCompleted(completedCheckpoint);
        this.pendingCheckpoints.remove(checkpointId).abortCheckpointTimeoutFutureWhenIsCompleted();
        this.pendingCounter.decrementAndGet();
        if (this.isCompleted()) {
            this.cleanPendingCheckpoint(CheckpointCloseReason.CHECKPOINT_COORDINATOR_COMPLETED);
            if (this.latestCompletedCheckpoint.getCheckpointType().isSavepoint()) {
                this.updateStatus(CheckpointCoordinatorStatus.SUSPEND);
                this.checkpointCoordinatorFuture.complete(new CheckpointCoordinatorState(CheckpointCoordinatorStatus.SUSPEND, null));
            } else {
                this.updateStatus(CheckpointCoordinatorStatus.FINISHED);
                this.checkpointCoordinatorFuture.complete(new CheckpointCoordinatorState(CheckpointCoordinatorStatus.FINISHED, null));
            }
        }
    }

    public InvocationFuture<?>[] notifyCheckpointCompleted(CompletedCheckpoint checkpoint) {
        if (checkpoint.getCheckpointType().isSchemaChangeAfterCheckpoint()) {
            this.completeSchemaChangeAfterCheckpoint(checkpoint);
        }
        return (InvocationFuture[])this.plan.getPipelineSubtasks().stream().map(taskLocation -> new CheckpointFinishedOperation((TaskLocation)taskLocation, checkpoint.getCheckpointId(), true)).map(this.checkpointManager::sendOperationToMemberNode).toArray(InvocationFuture[]::new);
    }

    public InvocationFuture<?>[] notifyCheckpointEnd(CompletedCheckpoint checkpoint) {
        if (checkpoint.getCheckpointType().isSchemaChangeCheckpoint()) {
            return (InvocationFuture[])this.plan.getPipelineSubtasks().stream().map(taskLocation -> new CheckpointEndOperation((TaskLocation)taskLocation, checkpoint.getCheckpointId(), true)).map(this.checkpointManager::sendOperationToMemberNode).toArray(InvocationFuture[]::new);
        }
        return new InvocationFuture[0];
    }

    public boolean isCompleted() {
        if (this.latestCompletedCheckpoint == null) {
            return false;
        }
        return this.latestCompletedCheckpoint.getCheckpointType().isFinalCheckpoint() && !this.latestCompletedCheckpoint.isRestored();
    }

    public boolean isNoErrorCompleted() {
        if (this.latestCompletedCheckpoint == null) {
            return false;
        }
        CheckpointCoordinatorStatus status = (CheckpointCoordinatorStatus)((Object)this.runningJobStateIMap.get(this.checkpointStateImapKey));
        return this.latestCompletedCheckpoint.getCheckpointType().isFinalCheckpoint() && (status.equals((Object)CheckpointCoordinatorStatus.FINISHED) || status.equals((Object)CheckpointCoordinatorStatus.SUSPEND)) && !this.latestCompletedCheckpoint.isRestored();
    }

    public boolean isEndOfSavePoint() {
        if (this.latestCompletedCheckpoint == null) {
            return false;
        }
        return this.latestCompletedCheckpoint.getCheckpointType().isSavepoint();
    }

    public PassiveCompletableFuture<CheckpointCoordinatorState> waitCheckpointCoordinatorComplete() {
        return new PassiveCompletableFuture<CheckpointCoordinatorState>(this.checkpointCoordinatorFuture);
    }

    public PassiveCompletableFuture<CheckpointCoordinatorState> cancelCheckpoint() {
        if (this.checkpointCoordinatorFuture.isDone()) {
            return new PassiveCompletableFuture<CheckpointCoordinatorState>(this.checkpointCoordinatorFuture);
        }
        this.cleanPendingCheckpoint(CheckpointCloseReason.PIPELINE_END);
        this.updateStatus(CheckpointCoordinatorStatus.CANCELED);
        CheckpointCoordinatorState checkpointCoordinatorState = new CheckpointCoordinatorState(CheckpointCoordinatorStatus.CANCELED, null);
        this.checkpointCoordinatorFuture.complete(checkpointCoordinatorState);
        return new PassiveCompletableFuture<CheckpointCoordinatorState>(this.checkpointCoordinatorFuture);
    }

    private synchronized void updateStatus(@NonNull CheckpointCoordinatorStatus targetStatus) {
        if (targetStatus == null) {
            throw new NullPointerException("targetStatus is marked non-null but is null");
        }
        try {
            RetryUtils.retryWithException(() -> {
                LOG.info(String.format("Turn %s state from %s to %s", new Object[]{this.checkpointStateImapKey, this.runningJobStateIMap.get(this.checkpointStateImapKey), targetStatus}));
                this.runningJobStateIMap.set(this.checkpointStateImapKey, (Object)targetStatus);
                return null;
            }, new RetryUtils.RetryMaterial(30, true, exception -> ExceptionUtil.isOperationNeedRetryException(exception), 2000L));
        }
        catch (Exception e) {
            LOG.warn(String.format("Set %s state %s to IMap failed, skip do it", new Object[]{this.checkpointStateImapKey, targetStatus}));
        }
    }

    protected void scheduleSchemaChangeBeforeCheckpoint() {
        if (this.schemaChanging.compareAndSet(false, true)) {
            LOG.info("stop trigger general-checkpoint({}@{}) because schema change in progress.", (Object)this.pipelineId, (Object)this.jobId);
            LOG.info("schedule schema-change-before checkpoint({}@{}).", (Object)this.pipelineId, (Object)this.jobId);
            this.scheduleTriggerPendingCheckpoint(CheckpointType.SCHEMA_CHANGE_BEFORE_POINT_TYPE, 0L);
        } else {
            LOG.warn("schema-change-before checkpoint({}@{}) is already scheduled.", (Object)this.pipelineId, (Object)this.jobId);
        }
    }

    protected void scheduleSchemaChangeAfterCheckpoint() {
        if (this.schemaChanging.get()) {
            LOG.info("schedule schema-change-after checkpoint({}@{}).", (Object)this.pipelineId, (Object)this.jobId);
            this.scheduleTriggerPendingCheckpoint(CheckpointType.SCHEMA_CHANGE_AFTER_POINT_TYPE, 0L);
        } else {
            LOG.warn("schema-change-after checkpoint({}@{}) is already scheduled.", (Object)this.pipelineId, (Object)this.jobId);
        }
    }

    protected void completeSchemaChangeAfterCheckpoint(CompletedCheckpoint checkpoint) {
        if (!this.schemaChanging.compareAndSet(true, false)) {
            throw new IllegalStateException(String.format("schema-change-after checkpoint(%s/%s@%s) is already completed.", checkpoint.getCheckpointId(), this.pipelineId, this.jobId));
        }
        LOG.info("completed schema-change-after checkpoint({}/{}@{}).", checkpoint.getCheckpointId(), this.pipelineId, this.jobId);
        LOG.info("recover trigger general-checkpoint({}/{}@{}).", checkpoint.getCheckpointId(), this.pipelineId, this.jobId);
        this.scheduleTriggerPendingCheckpoint(this.coordinatorConfig.getCheckpointInterval());
    }

    @VisibleForTesting
    public PendingCheckpoint getSavepointPendingCheckpoint() {
        return this.savepointPendingCheckpoint;
    }

    public CheckpointIDCounter getCheckpointIdCounter() {
        return this.checkpointIdCounter;
    }
}

