/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public class MetadataColumn
extends Column {
    private static final long serialVersionUID = 1L;
    private final String metadataKey;

    protected MetadataColumn(String name, SeaTunnelDataType<?> dataType, Long columnLength, String metadataKey, boolean nullable, Object defaultValue, String comment) {
        super(name, dataType, columnLength, nullable, defaultValue, comment);
        this.metadataKey = metadataKey;
    }

    public static MetadataColumn of(String name, SeaTunnelDataType<?> dataType, Long columnLength, String metadataKey, boolean nullable, Object defaultValue, String comment) {
        return new MetadataColumn(name, dataType, columnLength, metadataKey, nullable, defaultValue, comment);
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    @Override
    public Column copy(SeaTunnelDataType<?> newType) {
        return MetadataColumn.of(this.name, newType, this.columnLength, this.metadataKey, this.nullable, this.defaultValue, this.comment);
    }

    @Override
    public Column copy() {
        return MetadataColumn.of(this.name, this.dataType, this.columnLength, this.metadataKey, this.nullable, this.defaultValue, this.comment);
    }

    @Override
    public Column rename(String newColumnName) {
        return MetadataColumn.of(newColumnName, this.dataType, this.columnLength, this.metadataKey, this.nullable, this.defaultValue, this.comment);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataColumn)) {
            return false;
        }
        MetadataColumn other = (MetadataColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$metadataKey = this.metadataKey;
        String other$metadataKey = other.metadataKey;
        return !(this$metadataKey == null ? other$metadataKey != null : !this$metadataKey.equals(other$metadataKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MetadataColumn;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $metadataKey = this.metadataKey;
        result = result * 59 + ($metadataKey == null ? 43 : $metadataKey.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MetadataColumn(super=" + super.toString() + ", metadataKey=" + this.metadataKey + ")";
    }
}

