/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.impl.ProviderHelper;
import com.hazelcast.internal.monitor.impl.LocalExecutorStatsImpl;
import com.hazelcast.internal.partition.MigrationAwareService;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.MembershipAwareService;
import com.hazelcast.internal.services.MembershipServiceEvent;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.internal.services.SplitBrainHandlerService;
import com.hazelcast.internal.services.SplitBrainProtectionAwareService;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.map.impl.ExecutorStats;
import com.hazelcast.scheduledexecutor.impl.CapacityPermit;
import com.hazelcast.scheduledexecutor.impl.MemberCapacityPermit;
import com.hazelcast.scheduledexecutor.impl.NoopCapacityPermit;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainer;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainerCollector;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainerHolder;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorMemberBin;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorPartition;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorServiceProxy;
import com.hazelcast.scheduledexecutor.impl.ScheduledFutureProxy;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskDescriptor;
import com.hazelcast.scheduledexecutor.impl.operations.MergeOperation;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.merge.AbstractContainerMerger;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class DistributedScheduledExecutorService
implements ManagedService,
RemoteService,
MigrationAwareService,
SplitBrainProtectionAwareService,
SplitBrainHandlerService,
MembershipAwareService,
StatisticsAwareService<LocalExecutorStatsImpl>,
DynamicMetricsProvider {
    public static final int MEMBER_BIN = -1;
    public static final String SERVICE_NAME = "hz:impl:scheduledExecutorService";
    public static final CapacityPermit NOOP_PERMIT = new NoopCapacityPermit();
    static final AtomicBoolean FAIL_MIGRATIONS = new AtomicBoolean(false);
    private static final Object NULL_OBJECT = new Object();
    private final ExecutorStats executorStats = new ExecutorStats();
    private final ConcurrentMap<String, Boolean> shutdownExecutors = new ConcurrentHashMap<String, Boolean>();
    private final ConcurrentMap<String, CapacityPermit> permits = new ConcurrentHashMap<String, CapacityPermit>();
    private final Set<ScheduledFutureProxy> lossListeners = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final ConcurrentMap<String, Object> splitBrainProtectionConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory splitBrainProtectionConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> splitBrainProtectionConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            ScheduledExecutorConfig executorConfig = DistributedScheduledExecutorService.this.nodeEngine.getConfig().findScheduledExecutorConfig(name);
            String splitBrainProtectionName = executorConfig.getSplitBrainProtectionName();
            return splitBrainProtectionName == null ? NULL_OBJECT : splitBrainProtectionName;
        }
    };
    private NodeEngine nodeEngine;
    private ScheduledExecutorPartition[] partitions;
    private ScheduledExecutorMemberBin memberBin;
    private UUID partitionLostRegistration;

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.nodeEngine = nodeEngine;
        this.partitions = new ScheduledExecutorPartition[partitionCount];
        boolean dsMetricsEnabled = nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES);
        if (dsMetricsEnabled) {
            ((NodeEngineImpl)nodeEngine).getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
        this.reset();
    }

    public ScheduledExecutorPartition getPartition(int partitionId) {
        return this.partitions[partitionId];
    }

    public ScheduledExecutorContainerHolder getPartitionOrMemberBin(int id) {
        if (id == -1) {
            return this.memberBin;
        }
        return this.getPartition(id);
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public ExecutorStats getExecutorStats() {
        return this.executorStats;
    }

    @Override
    public void reset() {
        this.shutdown(true);
        this.memberBin = new ScheduledExecutorMemberBin(this.nodeEngine, this);
        if (this.partitionLostRegistration == null) {
            this.registerPartitionListener();
        }
        for (int partitionId = 0; partitionId < this.partitions.length; ++partitionId) {
            if (this.partitions[partitionId] != null) {
                this.partitions[partitionId].destroy();
            }
            this.partitions[partitionId] = new ScheduledExecutorPartition(this.nodeEngine, this, partitionId);
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        this.executorStats.clear();
        this.shutdownExecutors.clear();
        this.permits.clear();
        if (this.memberBin != null) {
            this.memberBin.destroy();
        }
        this.lossListeners.clear();
        this.unRegisterPartitionListenerIfExists();
        for (ScheduledExecutorPartition partition : this.partitions) {
            if (partition == null) continue;
            partition.destroy();
        }
    }

    CapacityPermit permitFor(String name, ScheduledExecutorConfig config) {
        return this.permits.computeIfAbsent(name, n -> new MemberCapacityPermit((String)n, config.getCapacity()));
    }

    void addLossListener(ScheduledFutureProxy future) {
        this.lossListeners.add(future);
    }

    @Override
    public DistributedObject createDistributedObject(String name, UUID source, boolean local) {
        ScheduledExecutorConfig executorConfig = this.nodeEngine.getConfig().findScheduledExecutorConfig(name);
        ConfigValidator.checkScheduledExecutorConfig(executorConfig, this.nodeEngine.getSplitBrainMergePolicyProvider());
        return new ScheduledExecutorServiceProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name, boolean local) {
        if (this.shutdownExecutors.remove(name) == null) {
            this.nodeEngine.getExecutionService().shutdownScheduledDurableExecutor(name);
        }
        this.resetPartitionOrMemberBinContainer(name);
        this.splitBrainProtectionConfigCache.remove(name);
    }

    public void shutdownExecutor(String name) {
        if (this.shutdownExecutors.putIfAbsent(name, Boolean.TRUE) == null) {
            this.nodeEngine.getExecutionService().shutdownScheduledDurableExecutor(name);
        }
    }

    public boolean isShutdown(String name) {
        return this.shutdownExecutors.containsKey(name);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        int partitionId = event.getPartitionId();
        ScheduledExecutorPartition partition = this.partitions[partitionId];
        return partition.prepareReplicationOperation(event.getReplicaIndex());
    }

    @Override
    public Runnable prepareMergeRunnable() {
        ScheduledExecutorContainerCollector collector = new ScheduledExecutorContainerCollector(this.nodeEngine, this.partitions);
        collector.run();
        return new Merger(collector);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
        if (FAIL_MIGRATIONS.getAndSet(false)) {
            throw new RuntimeException();
        }
        ScheduledExecutorPartition partition = this.partitions[event.getPartitionId()];
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE && event.getCurrentReplicaIndex() == 0) {
            partition.suspendTasks();
        }
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        int partitionId = event.getPartitionId();
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.discardReserved(partitionId, event.getNewReplicaIndex());
        } else if (event.getNewReplicaIndex() == 0) {
            ScheduledExecutorPartition partition = this.partitions[partitionId];
            partition.promoteSuspended();
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        int partitionId = event.getPartitionId();
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.discardReserved(event.getPartitionId(), event.getCurrentReplicaIndex());
        } else if (event.getCurrentReplicaIndex() == 0) {
            ScheduledExecutorPartition partition = this.partitions[partitionId];
            partition.promoteSuspended();
        }
    }

    private void discardReserved(int partitionId, int thresholdReplicaIndex) {
        ScheduledExecutorPartition partition = this.partitions[partitionId];
        partition.disposeObsoleteReplicas(thresholdReplicaIndex);
    }

    private void resetPartitionOrMemberBinContainer(String name) {
        this.permits.remove(name);
        if (this.memberBin != null) {
            this.memberBin.destroyContainer(name);
        }
        for (ScheduledExecutorPartition partition : this.partitions) {
            partition.destroyContainer(name);
        }
    }

    private void registerPartitionListener() {
        this.partitionLostRegistration = this.getNodeEngine().getPartitionService().addPartitionLostListener(event -> {
            ScheduledFutureProxy[] futures;
            for (ScheduledFutureProxy future : futures = this.lossListeners.toArray(new ScheduledFutureProxy[0])) {
                future.notifyPartitionLost(event);
            }
        });
    }

    private void unRegisterPartitionListenerIfExists() {
        block3: {
            if (this.partitionLostRegistration == null) {
                return;
            }
            try {
                this.getNodeEngine().getPartitionService().removePartitionLostListener(this.partitionLostRegistration);
            }
            catch (Exception ex) {
                if (!(ExceptionUtil.peel(ex, HazelcastInstanceNotActiveException.class, null) instanceof HazelcastInstanceNotActiveException)) break block3;
                throw ExceptionUtil.rethrow(ex);
            }
        }
        this.partitionLostRegistration = null;
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        ScheduledFutureProxy[] futures;
        for (ScheduledFutureProxy future : futures = this.lossListeners.toArray(new ScheduledFutureProxy[0])) {
            future.notifyMemberLost(event);
        }
    }

    @Override
    public String getSplitBrainProtectionName(String name) {
        Object splitBrainProtectionName = ConcurrencyUtil.getOrPutSynchronized(this.splitBrainProtectionConfigCache, name, this.splitBrainProtectionConfigCacheMutexFactory, this.splitBrainProtectionConfigConstructor);
        return splitBrainProtectionName == NULL_OBJECT ? null : (String)splitBrainProtectionName;
    }

    @Override
    public Map<String, LocalExecutorStatsImpl> getStats() {
        return this.executorStats.getStatsMap();
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        ProviderHelper.provide(descriptor, context, "scheduledExecutor", this.getStats());
    }

    private class Merger
    extends AbstractContainerMerger<ScheduledExecutorContainer, ScheduledTaskDescriptor, SplitBrainMergeTypes.ScheduledExecutorMergeTypes> {
        Merger(ScheduledExecutorContainerCollector collector) {
            super(collector, DistributedScheduledExecutorService.this.nodeEngine);
        }

        @Override
        protected String getLabel() {
            return "scheduled executors";
        }

        @Override
        public void runInternal() {
            ScheduledExecutorContainerCollector collector = (ScheduledExecutorContainerCollector)this.collector;
            SerializationService serializationService = DistributedScheduledExecutorService.this.nodeEngine.getSerializationService();
            ConcurrentMap containerMap = collector.getCollectedContainers();
            for (Map.Entry entry : containerMap.entrySet()) {
                int partitionId = (Integer)entry.getKey();
                Collection containers = (Collection)entry.getValue();
                for (ScheduledExecutorContainer container : containers) {
                    String name = container.getName();
                    MergePolicyConfig mergePolicyConfig = collector.getMergePolicyConfig(container);
                    SplitBrainMergePolicy<ScheduledTaskDescriptor, SplitBrainMergeTypes.ScheduledExecutorMergeTypes, ScheduledTaskDescriptor> mergePolicy = this.getMergePolicy(mergePolicyConfig);
                    int batchSize = mergePolicyConfig.getBatchSize();
                    ArrayList<SplitBrainMergeTypes.ScheduledExecutorMergeTypes> mergingEntries = new ArrayList<SplitBrainMergeTypes.ScheduledExecutorMergeTypes>(batchSize);
                    container.suspendTasks();
                    Map<String, ScheduledTaskDescriptor> tasks = container.prepareForReplication();
                    for (ScheduledTaskDescriptor descriptor : tasks.values()) {
                        SplitBrainMergeTypes.ScheduledExecutorMergeTypes mergingEntry = MergingValueFactory.createMergingEntry(serializationService, descriptor);
                        mergingEntries.add(mergingEntry);
                    }
                    if (mergingEntries.size() == batchSize) {
                        this.sendBatch(partitionId, name, mergingEntries, mergePolicy);
                        mergingEntries = new ArrayList(batchSize);
                    }
                    if (mergingEntries.isEmpty()) continue;
                    this.sendBatch(partitionId, name, mergingEntries, mergePolicy);
                }
            }
        }

        private void sendBatch(int partitionId, String name, List<SplitBrainMergeTypes.ScheduledExecutorMergeTypes> mergingEntries, SplitBrainMergePolicy<ScheduledTaskDescriptor, SplitBrainMergeTypes.ScheduledExecutorMergeTypes, ScheduledTaskDescriptor> mergePolicy) {
            MergeOperation operation = new MergeOperation(name, mergingEntries, mergePolicy);
            this.invoke(DistributedScheduledExecutorService.SERVICE_NAME, operation, partitionId);
        }
    }
}

