/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.util.LatencyDistribution;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class OperationProfilerPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.operation-profiler.period.seconds", 5, TimeUnit.SECONDS);
    private final OperationServiceImpl operationService;
    private final long periodMillis;
    private final ConcurrentMap<Class, LatencyDistribution> opLatencyDistribution;

    public OperationProfilerPlugin(NodeEngineImpl nodeEngine) {
        super(nodeEngine.getLogger(OperationProfilerPlugin.class));
        this.operationService = nodeEngine.getOperationService();
        this.periodMillis = this.getPeriodMillis(nodeEngine);
        this.opLatencyDistribution = this.operationService.getOpLatencyDistributions();
    }

    private long getPeriodMillis(NodeEngineImpl nodeEngine) {
        return nodeEngine.getProperties().getMillis(PERIOD_SECONDS);
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        this.logger.info("Plugin:active, period-millis:" + this.periodMillis);
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        writer.startSection("OperationsProfiler");
        OperationProfilerPlugin.write(writer, this.opLatencyDistribution);
        writer.endSection();
    }

    static void write(DiagnosticsLogWriter writer, ConcurrentMap<Class, LatencyDistribution> opLatencyDistribution) {
        for (Map.Entry entry : opLatencyDistribution.entrySet()) {
            LatencyDistribution distribution = (LatencyDistribution)entry.getValue();
            if (distribution.count() == 0L) continue;
            writer.startSection(((Class)entry.getKey()).getName());
            writer.writeKeyValueEntry("count", distribution.count());
            writer.writeKeyValueEntry("totalTime(us)", distribution.totalMicros());
            writer.writeKeyValueEntry("avg(us)", distribution.avgMicros());
            writer.writeKeyValueEntry("max(us)", distribution.maxMicros());
            writer.startSection("latency-distribution");
            for (int bucket = 0; bucket < distribution.bucketCount(); ++bucket) {
                long value = distribution.bucket(bucket);
                if (value <= 0L) continue;
                writer.writeKeyValueEntry(LatencyDistribution.LATENCY_KEYS[bucket], value);
            }
            writer.endSection();
            writer.endSection();
        }
    }
}

