/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorCancelFromMemberCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorCancelFromPartitionCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorDisposeFromMemberCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorDisposeFromPartitionCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetDelayFromMemberCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetDelayFromPartitionCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetResultFromMemberCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetResultFromPartitionCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetStatsFromMemberCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetStatsFromPartitionCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorIsCancelledFromMemberCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorIsCancelledFromPartitionCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorIsDoneFromMemberCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorIsDoneFromPartitionCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.ScheduledTaskStatistics;
import com.hazelcast.scheduledexecutor.StaleTaskException;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskStatisticsImpl;
import java.util.UUID;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientScheduledFutureProxy<V>
extends ClientProxy
implements IScheduledFuture<V> {
    private ScheduledTaskHandler handler;

    ClientScheduledFutureProxy(ScheduledTaskHandler handler, ClientContext context) {
        super("hz:impl:scheduledExecutorService", handler.getSchedulerName(), context);
        this.handler = handler;
    }

    @Override
    public ScheduledTaskHandler getHandler() {
        return this.handler;
    }

    @Override
    public ScheduledTaskStatistics getStats() {
        this.checkAccessibleHandler();
        UUID uuid = this.handler.getUuid();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        if (uuid != null) {
            ClientMessage request = ScheduledExecutorGetStatsFromMemberCodec.encodeRequest(schedulerName, taskName, uuid);
            ClientMessage response = (ClientMessage)this.invokeOnMember(request, uuid);
            ScheduledExecutorGetStatsFromMemberCodec.ResponseParameters responseParameters = ScheduledExecutorGetStatsFromMemberCodec.decodeResponse(response);
            return new ScheduledTaskStatisticsImpl(responseParameters.totalRuns, responseParameters.lastIdleTimeNanos, responseParameters.totalRunTimeNanos, responseParameters.totalIdleTimeNanos, responseParameters.lastRunDurationNanos);
        }
        ClientMessage request = ScheduledExecutorGetStatsFromPartitionCodec.encodeRequest(schedulerName, taskName);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, partitionId);
        ScheduledExecutorGetStatsFromMemberCodec.ResponseParameters responseParameters = ScheduledExecutorGetStatsFromMemberCodec.decodeResponse(response);
        return new ScheduledTaskStatisticsImpl(responseParameters.totalRuns, responseParameters.lastIdleTimeNanos, responseParameters.totalRunTimeNanos, responseParameters.totalIdleTimeNanos, responseParameters.lastRunDurationNanos);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        Preconditions.checkNotNull(unit, "Unit is null");
        this.checkAccessibleHandler();
        UUID uuid = this.handler.getUuid();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        if (uuid != null) {
            ClientMessage request = ScheduledExecutorGetDelayFromMemberCodec.encodeRequest(schedulerName, taskName, uuid);
            ClientMessage response = (ClientMessage)this.invokeOnMember(request, uuid);
            long nanos = ScheduledExecutorGetDelayFromMemberCodec.decodeResponse(response);
            return unit.convert(nanos, TimeUnit.NANOSECONDS);
        }
        ClientMessage request = ScheduledExecutorGetDelayFromPartitionCodec.encodeRequest(schedulerName, taskName);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, partitionId);
        long nanos = ScheduledExecutorGetDelayFromPartitionCodec.decodeResponse(response);
        return unit.convert(nanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (mayInterruptIfRunning) {
            throw new UnsupportedOperationException("mayInterruptIfRunning flag is not supported.");
        }
        this.checkAccessibleHandler();
        UUID uuid = this.handler.getUuid();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        if (uuid != null) {
            ClientMessage request = ScheduledExecutorCancelFromMemberCodec.encodeRequest(schedulerName, taskName, uuid, false);
            ClientMessage response = (ClientMessage)this.invokeOnMember(request, uuid);
            return ScheduledExecutorCancelFromMemberCodec.decodeResponse(response);
        }
        ClientMessage request = ScheduledExecutorCancelFromPartitionCodec.encodeRequest(schedulerName, taskName, false);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, partitionId);
        return ScheduledExecutorCancelFromPartitionCodec.decodeResponse(response);
    }

    @Override
    public boolean isCancelled() {
        this.checkAccessibleHandler();
        UUID uuid = this.handler.getUuid();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        if (uuid != null) {
            ClientMessage request = ScheduledExecutorIsCancelledFromMemberCodec.encodeRequest(schedulerName, taskName, uuid);
            ClientMessage response = (ClientMessage)this.invokeOnMember(request, uuid);
            return ScheduledExecutorIsCancelledFromMemberCodec.decodeResponse(response);
        }
        ClientMessage request = ScheduledExecutorIsCancelledFromPartitionCodec.encodeRequest(schedulerName, taskName);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, partitionId);
        return ScheduledExecutorIsCancelledFromPartitionCodec.decodeResponse(response);
    }

    @Override
    public boolean isDone() {
        this.checkAccessibleHandler();
        UUID uuid = this.handler.getUuid();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        if (uuid != null) {
            ClientMessage request = ScheduledExecutorIsDoneFromMemberCodec.encodeRequest(schedulerName, taskName, uuid);
            ClientMessage response = (ClientMessage)this.invokeOnMember(request, uuid);
            return ScheduledExecutorIsDoneFromMemberCodec.decodeResponse(response);
        }
        ClientMessage request = ScheduledExecutorIsDoneFromPartitionCodec.encodeRequest(schedulerName, taskName);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, partitionId);
        return ScheduledExecutorIsDoneFromPartitionCodec.decodeResponse(response);
    }

    private V get0(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkAccessibleHandler();
        UUID uuid = this.handler.getUuid();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        if (uuid != null) {
            ClientMessage request = ScheduledExecutorGetResultFromMemberCodec.encodeRequest(schedulerName, taskName, uuid);
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, (Object)schedulerName, uuid).invoke();
            ClientMessage response = (ClientMessage)future.get(timeout, unit);
            Data data = ScheduledExecutorGetResultFromMemberCodec.decodeResponse(response);
            return (V)this.toObject(data);
        }
        ClientMessage request = ScheduledExecutorGetResultFromPartitionCodec.encodeRequest(schedulerName, taskName);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, (Object)schedulerName, partitionId).invoke();
        ClientMessage response = (ClientMessage)future.get(timeout, unit);
        Data data = ScheduledExecutorGetResultFromPartitionCodec.decodeResponse(response);
        return (V)this.toObject(data);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get0(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (TimeoutException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Preconditions.checkNotNull(unit, "Unit is null");
        return this.get0(timeout, unit);
    }

    @Override
    public void dispose() {
        this.checkAccessibleHandler();
        UUID uuid = this.handler.getUuid();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        if (uuid != null) {
            ClientMessage request = ScheduledExecutorDisposeFromMemberCodec.encodeRequest(schedulerName, taskName, uuid);
            this.invokeOnMember(request, uuid);
        } else {
            ClientMessage request = ScheduledExecutorDisposeFromPartitionCodec.encodeRequest(schedulerName, taskName);
            this.invokeOnPartition(request, partitionId);
        }
        this.handler = null;
    }

    private void checkAccessibleHandler() {
        if (this.handler == null) {
            throw new StaleTaskException("Scheduled task was previously disposed.");
        }
    }
}

