/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.multimap;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MultiMapRemoveEntryCodec;
import com.hazelcast.client.impl.protocol.task.multimap.AbstractMultiMapPartitionMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.multimap.impl.operations.RemoveOperation;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;

public class MultiMapRemoveEntryMessageTask
extends AbstractMultiMapPartitionMessageTask<MultiMapRemoveEntryCodec.RequestParameters> {
    private transient long startTimeNanos;

    public MultiMapRemoveEntryMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void beforeProcess() {
        if (this.getContainer().getConfig().isStatisticsEnabled()) {
            this.startTimeNanos = Timer.nanos();
        }
    }

    @Override
    protected Object processResponseBeforeSending(Object response) {
        this.updateStats(stats -> stats.incrementRemoveLatencyNanos(Timer.nanosElapsed(this.startTimeNanos)));
        return response;
    }

    @Override
    protected Operation prepareOperation() {
        return new RemoveOperation(((MultiMapRemoveEntryCodec.RequestParameters)this.parameters).name, ((MultiMapRemoveEntryCodec.RequestParameters)this.parameters).key, ((MultiMapRemoveEntryCodec.RequestParameters)this.parameters).threadId, ((MultiMapRemoveEntryCodec.RequestParameters)this.parameters).value);
    }

    @Override
    protected MultiMapRemoveEntryCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MultiMapRemoveEntryCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MultiMapRemoveEntryCodec.encodeResponse((Boolean)response);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(((MultiMapRemoveEntryCodec.RequestParameters)this.parameters).name, "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MultiMapRemoveEntryCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "remove";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MultiMapRemoveEntryCodec.RequestParameters)this.parameters).key, ((MultiMapRemoveEntryCodec.RequestParameters)this.parameters).value};
    }
}

