/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.ogg;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;

public class OggJsonDeserializationSchema
implements DeserializationSchema<SeaTunnelRow> {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT = "Ogg";
    private static final String FIELD_TYPE = "op_type";
    private static final String FIELD_DATABASE_TABLE = "table";
    private static final String DATA_BEFORE = "before";
    private static final String DATA_AFTER = "after";
    private static final String OP_INSERT = "I";
    private static final String OP_UPDATE = "U";
    private static final String OP_DELETE = "D";
    private static final String REPLICA_IDENTITY_EXCEPTION = "The \"before\" field of %s operation message is null, if you are using Ogg Postgres Connector, please check the Postgres table has been set REPLICA IDENTITY to FULL level.";
    private String database;
    private String table;
    private final String[] fieldNames;
    private final int fieldCount;
    private boolean ignoreParseErrors;
    private final Pattern databasePattern;
    private final Pattern tablePattern;
    private final JsonDeserializationSchema jsonDeserializer;
    private final SeaTunnelRowType physicalRowType;

    public OggJsonDeserializationSchema(SeaTunnelRowType physicalRowType, String database, String table, boolean ignoreParseErrors) {
        this.physicalRowType = physicalRowType;
        SeaTunnelRowType jsonRowType = OggJsonDeserializationSchema.createJsonRowType(physicalRowType);
        this.jsonDeserializer = new JsonDeserializationSchema(false, ignoreParseErrors, jsonRowType);
        this.database = database;
        this.table = table;
        this.fieldNames = physicalRowType.getFieldNames();
        this.fieldCount = physicalRowType.getTotalFields();
        this.ignoreParseErrors = ignoreParseErrors;
        this.databasePattern = database == null ? null : Pattern.compile(database);
        this.tablePattern = table == null ? null : Pattern.compile(table);
    }

    public SeaTunnelRow deserialize(byte[] message) throws IOException {
        throw new UnsupportedOperationException("Please invoke DeserializationSchema#deserialize(byte[], Collector<SeaTunnelRow>) instead.");
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.physicalRowType;
    }

    private ObjectNode convertBytes(byte[] message) throws SeaTunnelRuntimeException {
        try {
            return (ObjectNode)this.jsonDeserializer.deserializeToJsonNode(message);
        }
        catch (Throwable t) {
            throw CommonError.jsonOperationError((String)FORMAT, (String)new String(message), (Throwable)t);
        }
    }

    public void deserialize(ObjectNode jsonNode, Collector<SeaTunnelRow> out) throws IOException {
        block10: {
            try {
                if (this.database != null && !this.databasePattern.matcher(jsonNode.get(FIELD_DATABASE_TABLE).asText().split("\\.")[0]).matches()) {
                    return;
                }
                if (this.table != null && !this.tablePattern.matcher(jsonNode.get(FIELD_DATABASE_TABLE).asText().split("\\.")[1]).matches()) {
                    return;
                }
                String op = jsonNode.get(FIELD_TYPE).asText().trim();
                if (OP_INSERT.equals(op)) {
                    JsonNode dataAfter = jsonNode.get(DATA_AFTER);
                    SeaTunnelRow row = this.convertJsonNode(dataAfter);
                    out.collect((Object)row);
                    break block10;
                }
                if (OP_UPDATE.equals(op)) {
                    JsonNode dataBefore = jsonNode.get(DATA_BEFORE);
                    if (dataBefore == null || dataBefore.isNull()) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "UPDATE"));
                    }
                    JsonNode dataAfter = jsonNode.get(DATA_AFTER);
                    SeaTunnelRow before = this.convertJsonNode(dataBefore);
                    SeaTunnelRow after = this.convertJsonNode(dataAfter);
                    before.setRowKind(RowKind.UPDATE_BEFORE);
                    out.collect((Object)before);
                    after.setRowKind(RowKind.UPDATE_AFTER);
                    out.collect((Object)after);
                    break block10;
                }
                if (OP_DELETE.equals(op)) {
                    JsonNode dataBefore = jsonNode.get(DATA_BEFORE);
                    if (dataBefore == null || dataBefore.isNull()) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "DELETE"));
                    }
                    SeaTunnelRow before = this.convertJsonNode(dataBefore);
                    if (before == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "DELETE"));
                    }
                    before.setRowKind(RowKind.DELETE);
                    out.collect((Object)before);
                    break block10;
                }
                throw new IllegalStateException(String.format("Unknown operation type '%s'.", op));
            }
            catch (RuntimeException e) {
                if (this.ignoreParseErrors) break block10;
                throw CommonError.jsonOperationError((String)FORMAT, (String)jsonNode.toString(), (Throwable)e);
            }
        }
    }

    public void deserialize(byte[] message, Collector<SeaTunnelRow> out) throws IOException {
        ObjectNode jsonNode;
        if (message == null || message.length == 0) {
            return;
        }
        try {
            jsonNode = this.convertBytes(message);
        }
        catch (RuntimeException e) {
            if (!this.ignoreParseErrors) {
                throw e;
            }
            return;
        }
        this.deserialize(jsonNode, out);
    }

    private SeaTunnelRow convertJsonNode(JsonNode root) {
        return this.jsonDeserializer.convertToRowData(root);
    }

    private static SeaTunnelRowType createJsonRowType(SeaTunnelRowType physicalDataType) {
        return physicalDataType;
    }

    public static Builder builder(SeaTunnelRowType physicalDataType) {
        return new Builder(physicalDataType);
    }

    public static class Builder {
        private boolean ignoreParseErrors = false;
        private String database = null;
        private String table = null;
        private final SeaTunnelRowType physicalDataType;

        public Builder(SeaTunnelRowType physicalDataType) {
            this.physicalDataType = physicalDataType;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setIgnoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public OggJsonDeserializationSchema build() {
            return new OggJsonDeserializationSchema(this.physicalDataType, this.database, this.table, this.ignoreParseErrors);
        }
    }
}

