# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
from setuptools import setup

__version__ = 'GRADLE_PROJECT_VERSION'

setup(
    name='nexusproto',
    version=__version__,
    url="https://github.com/apache/incubator-sdap-nexusproto",

    author="dev@sdap.apache.org",

    description="Protobufs used while ingesting NEXUS tiles.",

    packages=['nexusproto'],
    platforms='any',

    install_requires=[
        'protobuf==3.2.0'
    ],

    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 3.5',
    ]
)
