/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.snapshot.file;

import com.alibaba.fastjson.JSON;
import io.openmessaging.storage.dledger.snapshot.SnapshotMeta;
import io.openmessaging.storage.dledger.snapshot.SnapshotReader;
import io.openmessaging.storage.dledger.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSnapshotReader
implements SnapshotReader {
    private static Logger logger = LoggerFactory.getLogger(FileSnapshotReader.class);
    private final String snapshotStorePath;
    private SnapshotMeta snapshotMeta;

    public FileSnapshotReader(String snapshotStorePath) {
        this.snapshotStorePath = snapshotStorePath;
    }

    @Override
    public SnapshotMeta load() throws IOException {
        SnapshotMeta snapshotMetaFromJSON = (SnapshotMeta)JSON.parseObject((String)IOUtils.file2String(this.snapshotStorePath + File.separator + "snapshot_meta"), SnapshotMeta.class);
        if (snapshotMetaFromJSON == null) {
            return null;
        }
        this.snapshotMeta = snapshotMetaFromJSON;
        return this.snapshotMeta;
    }

    @Override
    public SnapshotMeta getSnapshotMeta() {
        return this.snapshotMeta != null ? this.snapshotMeta : null;
    }

    @Override
    public String getSnapshotStorePath() {
        return this.snapshotStorePath;
    }
}

