/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc;

import com.alipay.sofa.jraft.rpc.RpcContext;
import com.alipay.sofa.jraft.rpc.RpcProcessor;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.util.RpcFactoryHelper;
import com.google.protobuf.Message;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcRequestProcessor<T extends Message>
implements RpcProcessor<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(RpcRequestProcessor.class);
    private final Executor executor;
    private final Message defaultResp;

    public abstract Message processRequest(T var1, RpcRequestClosure var2);

    public RpcRequestProcessor(Executor executor, Message defaultResp) {
        this.executor = executor;
        this.defaultResp = defaultResp;
    }

    @Override
    public void handleRequest(RpcContext rpcCtx, T request) {
        try {
            Message msg = this.processRequest(request, new RpcRequestClosure(rpcCtx, this.defaultResp));
            if (msg != null) {
                rpcCtx.sendResponse(msg);
            }
        }
        catch (Throwable t) {
            LOG.error("handleRequest {} failed", request, (Object)t);
            rpcCtx.sendResponse(RpcFactoryHelper.responseFactory().newResponse(this.defaultResp(), -1, "handleRequest internal error", new Object[0]));
        }
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    public Message defaultResp() {
        return this.defaultResp;
    }
}

