/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.route;

import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.rocketmq.proxy.common.Address;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.QueueData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class ProxyTopicRouteData {
    private List<QueueData> queueDatas = new ArrayList<QueueData>();
    private List<ProxyBrokerData> brokerDatas = new ArrayList<ProxyBrokerData>();

    public ProxyTopicRouteData() {
    }

    public ProxyTopicRouteData(TopicRouteData topicRouteData) {
        this.queueDatas = topicRouteData.getQueueDatas();
        this.brokerDatas = new ArrayList<ProxyBrokerData>();
        for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
            ProxyBrokerData proxyBrokerData = new ProxyBrokerData();
            proxyBrokerData.setCluster(brokerData.getCluster());
            proxyBrokerData.setBrokerName(brokerData.getBrokerName());
            brokerData.getBrokerAddrs().forEach((brokerId, brokerAddr) -> {
                HostAndPort brokerHostAndPort = HostAndPort.fromString((String)brokerAddr);
                proxyBrokerData.getBrokerAddrs().put((Long)brokerId, Lists.newArrayList((Object[])new Address[]{new Address(brokerHostAndPort)}));
            });
            this.brokerDatas.add(proxyBrokerData);
        }
    }

    public ProxyTopicRouteData(TopicRouteData topicRouteData, int port) {
        this.queueDatas = topicRouteData.getQueueDatas();
        this.brokerDatas = new ArrayList<ProxyBrokerData>();
        for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
            ProxyBrokerData proxyBrokerData = new ProxyBrokerData();
            proxyBrokerData.setCluster(brokerData.getCluster());
            proxyBrokerData.setBrokerName(brokerData.getBrokerName());
            brokerData.getBrokerAddrs().forEach((brokerId, brokerAddr) -> {
                HostAndPort brokerHostAndPort = HostAndPort.fromString((String)brokerAddr);
                HostAndPort proxyHostAndPort = HostAndPort.fromParts((String)brokerHostAndPort.getHost(), (int)port);
                proxyBrokerData.getBrokerAddrs().put((Long)brokerId, Lists.newArrayList((Object[])new Address[]{new Address(proxyHostAndPort)}));
            });
            this.brokerDatas.add(proxyBrokerData);
        }
    }

    public ProxyTopicRouteData(TopicRouteData topicRouteData, List<Address> requestHostAndPortList) {
        this.queueDatas = topicRouteData.getQueueDatas();
        this.brokerDatas = new ArrayList<ProxyBrokerData>();
        for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
            ProxyBrokerData proxyBrokerData = new ProxyBrokerData();
            proxyBrokerData.setCluster(brokerData.getCluster());
            proxyBrokerData.setBrokerName(brokerData.getBrokerName());
            for (Long brokerId : brokerData.getBrokerAddrs().keySet()) {
                proxyBrokerData.getBrokerAddrs().put(brokerId, requestHostAndPortList);
            }
            this.brokerDatas.add(proxyBrokerData);
        }
    }

    public List<QueueData> getQueueDatas() {
        return this.queueDatas;
    }

    public void setQueueDatas(List<QueueData> queueDatas) {
        this.queueDatas = queueDatas;
    }

    public List<ProxyBrokerData> getBrokerDatas() {
        return this.brokerDatas;
    }

    public void setBrokerDatas(List<ProxyBrokerData> brokerDatas) {
        this.brokerDatas = brokerDatas;
    }

    public TopicRouteData buildTopicRouteData() {
        TopicRouteData topicRouteData = new TopicRouteData();
        topicRouteData.setQueueDatas(this.queueDatas);
        topicRouteData.setBrokerDatas(this.brokerDatas.stream().map(ProxyBrokerData::buildBrokerData).collect(Collectors.toList()));
        return topicRouteData;
    }

    public static class ProxyBrokerData {
        private String cluster;
        private String brokerName;
        private Map<Long, List<Address>> brokerAddrs = new HashMap<Long, List<Address>>();

        public String getCluster() {
            return this.cluster;
        }

        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public String getBrokerName() {
            return this.brokerName;
        }

        public void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        public Map<Long, List<Address>> getBrokerAddrs() {
            return this.brokerAddrs;
        }

        public void setBrokerAddrs(Map<Long, List<Address>> brokerAddrs) {
            this.brokerAddrs = brokerAddrs;
        }

        public BrokerData buildBrokerData() {
            BrokerData brokerData = new BrokerData();
            brokerData.setCluster(this.cluster);
            brokerData.setBrokerName(this.brokerName);
            HashMap buildBrokerAddress = new HashMap();
            this.brokerAddrs.forEach((k, v) -> {
                if (!v.isEmpty()) {
                    buildBrokerAddress.put(k, ((Address)v.get(0)).getHostAndPort().toString());
                }
            });
            brokerData.setBrokerAddrs(buildBrokerAddress);
            return brokerData;
        }
    }
}

