/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.MemoryGroup;
import org.apache.catalina.users.MemoryGroupCreationFactory;
import org.apache.catalina.users.MemoryRole;
import org.apache.catalina.users.MemoryRoleCreationFactory;
import org.apache.catalina.users.MemoryUser;
import org.apache.catalina.users.MemoryUserCreationFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.res.StringManager;

public class MemoryUserDatabase
implements UserDatabase {
    private static final Log log = LogFactory.getLog(MemoryUserDatabase.class);
    private static final StringManager sm = StringManager.getManager(MemoryUserDatabase.class);
    protected final Map<String, Group> groups = new ConcurrentHashMap<String, Group>();
    protected final String id;
    protected String pathname = "conf/tomcat-users.xml";
    protected String pathnameOld = this.pathname + ".old";
    protected String pathnameNew = this.pathname + ".new";
    protected boolean readonly = true;
    protected final Map<String, Role> roles = new ConcurrentHashMap<String, Role>();
    protected final Map<String, User> users = new ConcurrentHashMap<String, User>();
    private final ReentrantReadWriteLock dbLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.dbLock.readLock();
    private final Lock writeLock = this.dbLock.writeLock();
    private volatile long lastModified = 0L;
    private boolean watchSource = true;

    public MemoryUserDatabase() {
        this(null);
    }

    public MemoryUserDatabase(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Group> getGroups() {
        this.readLock.lock();
        try {
            Iterator<Group> iterator = new ArrayList<Group>(this.groups.values()).iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
        this.pathnameOld = pathname + ".old";
        this.pathnameNew = pathname + ".new";
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean getWatchSource() {
        return this.watchSource;
    }

    public void setWatchSource(boolean watchSource) {
        this.watchSource = watchSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Role> getRoles() {
        this.readLock.lock();
        try {
            Iterator<Role> iterator = new ArrayList<Role>(this.roles.values()).iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<User> getUsers() {
        this.readLock.lock();
        try {
            Iterator<User> iterator = new ArrayList<User>(this.users.values()).iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        this.writeLock.lock();
        try {
            this.save();
            this.users.clear();
            this.groups.clear();
            this.roles.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(String groupname, String description) {
        if (groupname == null || groupname.length() == 0) {
            String msg = sm.getString("memoryUserDatabase.nullGroup");
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        MemoryGroup group = new MemoryGroup(this, groupname, description);
        this.readLock.lock();
        try {
            this.groups.put(group.getGroupname(), group);
        }
        finally {
            this.readLock.unlock();
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role createRole(String rolename, String description) {
        if (rolename == null || rolename.length() == 0) {
            String msg = sm.getString("memoryUserDatabase.nullRole");
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        MemoryRole role = new MemoryRole(this, rolename, description);
        this.readLock.lock();
        try {
            this.roles.put(role.getRolename(), role);
        }
        finally {
            this.readLock.unlock();
        }
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createUser(String username, String password, String fullName) {
        if (username == null || username.length() == 0) {
            String msg = sm.getString("memoryUserDatabase.nullUser");
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        MemoryUser user = new MemoryUser(this, username, password, fullName);
        this.readLock.lock();
        try {
            this.users.put(user.getUsername(), user);
        }
        finally {
            this.readLock.unlock();
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group findGroup(String groupname) {
        this.readLock.lock();
        try {
            Group group = this.groups.get(groupname);
            return group;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role findRole(String rolename) {
        this.readLock.lock();
        try {
            Role role = this.roles.get(rolename);
            return role;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User findUser(String username) {
        this.readLock.lock();
        try {
            User user = this.users.get(username);
            return user;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void open() throws Exception {
        this.writeLock.lock();
        try {
            this.users.clear();
            this.groups.clear();
            this.roles.clear();
            String pathName = this.getPathname();
            URI uri = ConfigFileLoader.getURI(pathName);
            URLConnection uConn = null;
            URL url = uri.toURL();
            uConn = url.openConnection();
            InputStream is = uConn.getInputStream();
            this.lastModified = uConn.getLastModified();
            Digester digester = new Digester();
            try {
                digester.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (Exception e) {
                log.warn(sm.getString("memoryUserDatabase.xmlFeatureEncoding"), e);
            }
            digester.addFactoryCreate("tomcat-users/group", new MemoryGroupCreationFactory(this), true);
            digester.addFactoryCreate("tomcat-users/role", new MemoryRoleCreationFactory(this), true);
            digester.addFactoryCreate("tomcat-users/user", new MemoryUserCreationFactory(this), true);
            digester.parse(is);
            if (uConn == null) return;
            try {
                uConn.getInputStream().close();
                return;
            }
            catch (IOException ioe) {
                log.warn(sm.getString("memoryUserDatabase.fileClose", this.pathname), ioe);
            }
            return;
            catch (IOException ioe) {
                log.error(sm.getString("memoryUserDatabase.fileNotFound", pathName));
                if (uConn == null) return;
                try {
                    uConn.getInputStream().close();
                    return;
                }
                catch (IOException ioe2) {
                    log.warn(sm.getString("memoryUserDatabase.fileClose", this.pathname), ioe2);
                }
                return;
            }
            catch (Exception e) {
                this.users.clear();
                this.groups.clear();
                this.roles.clear();
                throw e;
                {
                    catch (Throwable throwable) {
                        if (uConn == null) throw throwable;
                        try {
                            uConn.getInputStream().close();
                            throw throwable;
                        }
                        catch (IOException ioe2) {
                            log.warn(sm.getString("memoryUserDatabase.fileClose", this.pathname), ioe2);
                        }
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(Group group) {
        this.readLock.lock();
        try {
            Iterator<User> users = this.getUsers();
            while (users.hasNext()) {
                User user = users.next();
                user.removeGroup(group);
            }
            this.groups.remove(group.getGroupname());
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRole(Role role) {
        this.readLock.lock();
        try {
            Iterator<Group> groups = this.getGroups();
            while (groups.hasNext()) {
                Group group = groups.next();
                group.removeRole(role);
            }
            Iterator<User> users = this.getUsers();
            while (users.hasNext()) {
                User user = users.next();
                user.removeRole(role);
            }
            this.roles.remove(role.getRolename());
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(User user) {
        this.readLock.lock();
        try {
            this.users.remove(user.getUsername());
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isWriteable() {
        File dir;
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.pathname);
        }
        return (dir = file.getParentFile()).exists() && dir.isDirectory() && dir.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws Exception {
        if (this.getReadonly()) {
            log.error(sm.getString("memoryUserDatabase.readOnly"));
            return;
        }
        if (!this.isWriteable()) {
            log.warn(sm.getString("memoryUserDatabase.notPersistable"));
            return;
        }
        File fileNew = new File(this.pathnameNew);
        if (!fileNew.isAbsolute()) {
            fileNew = new File(System.getProperty("catalina.base"), this.pathnameNew);
        }
        this.writeLock.lock();
        try {
            try (FileOutputStream fos = new FileOutputStream(fileNew);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                 PrintWriter writer = new PrintWriter(osw);){
                writer.println("<?xml version='1.0' encoding='utf-8'?>");
                writer.println("<tomcat-users xmlns=\"http://tomcat.apache.org/xml\"");
                writer.print("              ");
                writer.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                writer.print("              ");
                writer.println("xsi:schemaLocation=\"http://tomcat.apache.org/xml tomcat-users.xsd\"");
                writer.println("              version=\"1.0\">");
                Iterator<Principal> values = null;
                values = this.getRoles();
                while (values.hasNext()) {
                    writer.print("  ");
                    writer.println(values.next());
                }
                values = this.getGroups();
                while (values.hasNext()) {
                    writer.print("  ");
                    writer.println(values.next());
                }
                values = this.getUsers();
                while (values.hasNext()) {
                    writer.print("  ");
                    writer.println(((MemoryUser)values.next()).toXml());
                }
                writer.println("</tomcat-users>");
                if (writer.checkError()) {
                    throw new IOException(sm.getString("memoryUserDatabase.writeException", fileNew.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                if (fileNew.exists() && !fileNew.delete()) {
                    log.warn(sm.getString("memoryUserDatabase.fileDelete", fileNew));
                }
                throw e;
            }
            this.lastModified = fileNew.lastModified();
        }
        finally {
            this.writeLock.unlock();
        }
        File fileOld = new File(this.pathnameOld);
        if (!fileOld.isAbsolute()) {
            fileOld = new File(System.getProperty("catalina.base"), this.pathnameOld);
        }
        if (fileOld.exists() && !fileOld.delete()) {
            throw new IOException(sm.getString("memoryUserDatabase.fileDelete", fileOld));
        }
        File fileOrig = new File(this.pathname);
        if (!fileOrig.isAbsolute()) {
            fileOrig = new File(System.getProperty("catalina.base"), this.pathname);
        }
        if (fileOrig.exists() && !fileOrig.renameTo(fileOld)) {
            throw new IOException(sm.getString("memoryUserDatabase.renameOld", fileOld.getAbsolutePath()));
        }
        if (!fileNew.renameTo(fileOrig)) {
            if (fileOld.exists() && !fileOld.renameTo(fileOrig)) {
                log.warn(sm.getString("memoryUserDatabase.restoreOrig", fileOld));
            }
            throw new IOException(sm.getString("memoryUserDatabase.renameNew", fileOrig.getAbsolutePath()));
        }
        if (fileOld.exists() && !fileOld.delete()) {
            throw new IOException(sm.getString("memoryUserDatabase.fileDelete", fileOld));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void backgroundProcess() {
        if (!this.watchSource) {
            return;
        }
        URI uri = ConfigFileLoader.getURI(this.getPathname());
        URLConnection uConn = null;
        URL url = uri.toURL();
        uConn = url.openConnection();
        if (this.lastModified != uConn.getLastModified()) {
            this.writeLock.lock();
            try {
                long detectedLastModified = uConn.getLastModified();
                if (this.lastModified != detectedLastModified && detectedLastModified + 2000L < System.currentTimeMillis()) {
                    log.info(sm.getString("memoryUserDatabase.reload", this.id, uri));
                    this.open();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (uConn == null) return;
        try {
            uConn.getInputStream().close();
            return;
        }
        catch (IOException ioe) {
            log.warn(sm.getString("memoryUserDatabase.fileClose", this.pathname), ioe);
        }
        return;
        catch (Exception ioe) {
            try {
                log.error(sm.getString("memoryUserDatabase.reloadError", this.id, uri), ioe);
                if (uConn == null) return;
            }
            catch (Throwable throwable) {
                if (uConn == null) throw throwable;
                try {
                    uConn.getInputStream().close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    log.warn(sm.getString("memoryUserDatabase.fileClose", this.pathname), ioe2);
                }
                throw throwable;
            }
            try {
                uConn.getInputStream().close();
                return;
            }
            catch (IOException ioe3) {
                log.warn(sm.getString("memoryUserDatabase.fileClose", this.pathname), ioe3);
            }
            return;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MemoryUserDatabase[id=");
        sb.append(this.id);
        sb.append(",pathname=");
        sb.append(this.pathname);
        sb.append(",groupCount=");
        sb.append(this.groups.size());
        sb.append(",roleCount=");
        sb.append(this.roles.size());
        sb.append(",userCount=");
        sb.append(this.users.size());
        sb.append("]");
        return sb.toString();
    }
}

